/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.StructurePaneComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureTreeDecorator {
    private StructureTreeDecorator() {
    }

    static void decorate(@NotNull ColoredTextContainer container, @NotNull NlComponent component2) {
        StructureTreeDecorator.append(container, component2);
        container.setIcon(StructureTreeDecorator.getViewHandler(component2).getIcon(component2));
    }

    static void decorate(@NotNull ColoredTextContainer container, @NotNull String text) {
        container.append(text, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
    }

    @NotNull
    public static String toString(@NotNull NlComponent component2) {
        StringBuilderContainer container = new StringBuilderContainer();
        StructureTreeDecorator.append(container, component2);
        return ((Object)container).toString();
    }

    private static void append(@NotNull ColoredTextContainer container, @NotNull NlComponent component2) {
        String attributes;
        StructurePaneComponentHandler handler;
        String title;
        String id = LintUtils.stripIdPrefix((String)component2.getId());
        if (!id.isEmpty()) {
            container.append(id, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (!StringUtil.startsWithIgnoreCase((String)id, (String)(title = (handler = StructureTreeDecorator.getViewHandler(component2)).getTitle(component2)))) {
            container.append(id.isEmpty() ? title : " (" + title + ')', SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (!(attributes = handler.getTitleAttributes(component2)).isEmpty()) {
            container.append(' ' + attributes, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (PropertiesComponent.getInstance().getBoolean("NlBoundsVisible")) {
            String fragment = " (" + NlComponentHelperKt.getX(component2) + ", " + NlComponentHelperKt.getY(component2) + ") " + NlComponentHelperKt.getW(component2) + " \u00d7 " + NlComponentHelperKt.getH(component2);
            container.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    private static StructurePaneComponentHandler getViewHandler(@NotNull NlComponent component2) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        return handler == null ? ViewHandlerManager.NONE : handler;
    }

    private static final class StringBuilderContainer
    implements ColoredTextContainer {
        private final StringBuilder myBuilder = new StringBuilder();

        private StringBuilderContainer() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            this.myBuilder.append(fragment);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull Object tag) {
            throw new UnsupportedOperationException();
        }

        public void setIcon(@Nullable Icon icon) {
            throw new UnsupportedOperationException();
        }

        public void setToolTipText(@Nullable String text) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String toString() {
            return this.myBuilder.toString();
        }
    }
}

