/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class ConstraintsLayer
extends Layer {
    private final ScreenView myScreenView;
    private final NlDesignSurface myDesignSurface;
    private Dimension myScreenViewSize = new Dimension();
    private Rectangle mySizeRectangle = new Rectangle();
    private final boolean showOnSelection;
    private boolean myShowOnHover = false;
    private boolean myTemporaryShow = false;

    public ConstraintsLayer(NlDesignSurface designSurface, @NotNull ScreenView screenView, boolean showOnSelection) {
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
        this.showOnSelection = showOnSelection;
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value) {
        this.myShowOnHover = value;
    }

    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, gc.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        NlModel myModel = this.myScreenView.getModel();
        if (!this.myTemporaryShow && !this.myShowOnHover && this.showOnSelection) {
            return;
        }
        if (myModel.getComponents().isEmpty()) {
            return;
        }
        NlComponent component2 = (NlComponent)myModel.getComponents().get(0);
        component2 = component2.getRoot();
        Graphics2D g = (Graphics2D)gc.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.drawComponent(g, component2, false)) {
            Dimension size = this.myScreenView.getSize();
            if (size.width != 0 && size.height != 0) {
                this.myDesignSurface.repaint(this.myScreenView.getX(), this.myScreenView.getY(), size.width, size.height);
            } else {
                this.myDesignSurface.repaint();
            }
        }
        g.dispose();
    }

    private boolean drawComponent(@NotNull Graphics2D gc, @NotNull NlComponent component2, boolean parentHandlesPainting) {
        if (NlComponentHelperKt.getViewInfo(component2) != null) {
            ViewGroupHandler viewGroupHandler;
            ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
            boolean handlesPainting = false;
            if (handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting()) {
                viewGroupHandler.drawGroup(gc, this.myScreenView, component2);
                handlesPainting = true;
            }
            if (handler != null) {
                handler.paintConstraints(this.myScreenView, gc, component2);
            }
        }
        boolean needsRepaint = false;
        for (NlComponent child : component2.getChildren()) {
            needsRepaint |= this.drawComponent(gc, child, parentHandlesPainting);
        }
        return needsRepaint;
    }

    @Override
    public void hover(int x, int y) {
        boolean show = false;
        if (this.getScreenView() == this.myDesignSurface.getHoverSceneView(x, y)) {
            show = true;
        }
        if (this.isShowOnHover() != show) {
            this.setShowOnHover(show);
            this.myDesignSurface.repaint();
        }
    }

    public void setTemporaryShow(boolean temporaryShow) {
        this.myTemporaryShow = temporaryShow;
    }
}

