/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.inspector.NlInspectorProviders;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.idea.uibuilder.surface.PanZoomPanel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.SelectionLayer;
import com.android.tools.idea.uibuilder.surface.WarningLayer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface {
    @NotNull
    private static ScreenMode ourDefaultScreenMode = ScreenMode.loadPreferredMode();
    @NotNull
    private ScreenMode myScreenMode = ourDefaultScreenMode;
    @Nullable
    private ScreenView myBlueprintView;
    private int myScreenX = 70;
    private int myScreenY = 70;
    private boolean myIsCanvasResizing = false;
    private boolean myStackVertically;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myCentered;
    @Nullable
    private ScreenView myScreenView;
    private final boolean myInPreview;
    private WeakReference<PanZoomPanel> myPanZoomPanel = new WeakReference<Object>(null);
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();

    public NlDesignSurface(@NotNull Project project, boolean inPreview, @NotNull Disposable parentDisposable) {
        super(project, parentDisposable);
        this.myInPreview = inPreview;
    }

    public boolean isPreviewSurface() {
        return this.myInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @Override
    public void activate() {
        super.activate();
        this.showPanZoomPanelIfRequired();
    }

    @NotNull
    public ScreenMode getScreenMode() {
        return this.myScreenMode;
    }

    public void setScreenMode(@NotNull ScreenMode screenMode, boolean setAsDefault) {
        if (setAsDefault && ourDefaultScreenMode != screenMode) {
            ourDefaultScreenMode = screenMode;
            ScreenMode.savePreferredMode(screenMode);
        }
        if (screenMode != this.myScreenMode) {
            boolean adjustZoom = screenMode == ScreenMode.BOTH || this.myScreenMode == ScreenMode.BOTH;
            this.myScreenMode = screenMode;
            this.createSceneViews();
            if (this.myScreenView != null && adjustZoom) {
                this.zoomToFit();
            }
            if (screenMode != ScreenMode.BLUEPRINT_ONLY) {
                SceneManager manager = this.getSceneManager();
                if (manager != null) {
                    manager.requestRender();
                }
            } else {
                this.repaint();
            }
        }
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        return new LayoutlibSceneManager(model, this);
    }

    private void setLayers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new MyBottomLayer());
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                assert (this.myScreenView != null);
                builder.addAll(NlDesignSurface.getScreenLayers(this, this.myScreenView));
                break;
            }
            case BLUEPRINT_ONLY: {
                assert (this.myScreenView != null);
                builder.addAll(NlDesignSurface.getBlueprintLayers(this, this.myScreenView));
                break;
            }
            case BOTH: {
                assert (this.myScreenView != null && this.myBlueprintView != null);
                builder.addAll(NlDesignSurface.getScreenLayers(this, this.myScreenView));
                builder.addAll(NlDesignSurface.getBlueprintLayers(this, this.myBlueprintView));
                break;
            }
            default: {
                assert (false) : this.myScreenMode;
                break;
            }
        }
        this.setLayers((ImmutableList<Layer>)builder.build());
    }

    @NotNull
    private static ImmutableList<Layer> getScreenLayers(@NotNull NlDesignSurface surface, @NotNull ScreenView screenView) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new ScreenViewLayer(screenView));
        builder.add((Object)new SelectionLayer(screenView));
        if (screenView.getModel().getType().isLayout()) {
            builder.add((Object)new ConstraintsLayer(surface, screenView, true));
        }
        SceneLayer sceneLayer = new SceneLayer(surface, screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder.add((Object)new WarningLayer(screenView));
        builder.add((Object)sceneLayer);
        if (surface.getLayoutType().isSupportedByDesigner()) {
            builder.add((Object)new CanvasResizeLayer(surface, screenView));
        }
        return builder.build();
    }

    @NotNull
    private static ImmutableList<Layer> getBlueprintLayers(@NotNull NlDesignSurface surface, @NotNull ScreenView view) {
        return ImmutableList.of((Object)new SelectionLayer(view), (Object)new MockupLayer(view), (Object)new CanvasResizeLayer(surface, view), (Object)new SceneLayer(surface, view, true));
    }

    public void forceLayersPaint(boolean value) {
        for (Layer layer : this.getLayers()) {
            if (layer instanceof ConstraintsLayer) {
                ConstraintsLayer constraintsLayer = (ConstraintsLayer)layer;
                constraintsLayer.setTemporaryShow(value);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value);
            this.repaint();
        }
    }

    @Override
    @Nullable
    public ScreenView getCurrentSceneView() {
        return this.myScreenView;
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && y >= this.myBlueprintView.getY()) {
            return this.myBlueprintView;
        }
        return this.myScreenView;
    }

    @Override
    @Nullable
    public ScreenView getHoverSceneView(int x, int y) {
        if (this.myBlueprintView != null && x >= this.myBlueprintView.getX() && x <= this.myBlueprintView.getX() + this.myBlueprintView.getSize().width && y >= this.myBlueprintView.getY() && y <= this.myBlueprintView.getY() + this.myBlueprintView.getSize().height) {
            return this.myBlueprintView;
        }
        if (this.myScreenView != null && x >= this.myScreenView.getX() && x <= this.myScreenView.getX() + this.myScreenView.getSize().width && y >= this.myScreenView.getY() && y <= this.myScreenView.getY() + this.myScreenView.getSize().height) {
            return this.myScreenView;
        }
        return null;
    }

    @Override
    @NotNull
    public NlInspectorProviders getInspectorProviders(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        return new NlInspectorProviders(propertiesManager, parentDisposable);
    }

    @Nullable
    public ScreenView getBlueprintView() {
        return this.myBlueprintView;
    }

    @Override
    public Dimension getScrolledAreaSize() {
        if (this.myScreenView == null) {
            return null;
        }
        Dimension size = this.myScreenView.getSize();
        Dimension dimension = new Dimension(size.width + 100, size.height + 100);
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (this.isStackVertically()) {
                dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)size.height + 10.0);
            } else {
                dimension.setSize(dimension.getWidth() + (double)size.width + 10.0, dimension.getHeight());
            }
        }
        return dimension;
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        return this.myAdaptiveIconShape;
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    @NotNull
    protected NlActionManager createActionManager() {
        return new NlActionManager(this);
    }

    @Override
    protected void layoutContent() {
        if (this.myScreenView == null) {
            return;
        }
        Dimension screenViewSize = this.myScreenView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.myScreenMode == ScreenMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = Math.max((availableWidth - requiredWidth) / 2, 70);
                int requiredHeight = screenViewSize.height;
                if (this.myScreenMode == ScreenMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = Math.max((availableHeight - requiredHeight) / 2, 70);
            } else if (this.myDeviceFrames) {
                this.myScreenX = 120;
                this.myScreenY = 120;
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        this.myScreenView.setLocation(this.myScreenX, this.myScreenY);
        if (this.myBlueprintView != null) {
            if (this.myStackVertically) {
                this.myBlueprintView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                this.myBlueprintView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
        if (this.myScreenView != null) {
            Scene scene = this.myScreenView.getScene();
            scene.needsRebuildList();
        }
        if (this.myBlueprintView != null) {
            Scene scene = this.myBlueprintView.getScene();
            scene.needsRebuildList();
        }
    }

    @Override
    protected int getContentOriginX() {
        return this.myScreenX;
    }

    @Override
    protected int getContentOriginY() {
        return this.myScreenY;
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    @Override
    protected void doCreateSceneViews() {
        this.myScreenView = null;
        this.myBlueprintView = null;
        if (this.myModel == null) {
            return;
        }
        NlLayoutType type = this.myModel.getType();
        if (type.equals((Object)NlLayoutType.MENU)) {
            this.doCreateSceneViewsForMenu();
            return;
        }
        if (type.equals((Object)NlLayoutType.PREFERENCE_SCREEN)) {
            this.myScreenMode = ScreenMode.SCREEN_ONLY;
        }
        switch (this.myScreenMode) {
            case SCREEN_ONLY: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
                break;
            }
            case BLUEPRINT_ONLY: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, this.myModel);
                break;
            }
            case BOTH: {
                this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
                this.myBlueprintView = new ScreenView(this, ScreenView.ScreenViewType.BLUEPRINT, this.myModel);
                this.myBlueprintView.setLocation(this.myScreenX + this.myScreenView.getPreferredSize().width + 10, this.myScreenY);
            }
        }
        this.updateErrorDisplay();
        this.getLayeredPane().setPreferredSize(this.myScreenView.getPreferredSize());
        this.setLayers();
        this.layoutContent();
    }

    private void doCreateSceneViewsForMenu() {
        this.myScreenMode = ScreenMode.SCREEN_ONLY;
        XmlTag tag = this.myModel.getFile().getRootTag();
        if (tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            this.myScreenView = new NavigationViewSceneView(this, this.myModel);
            this.setLayers((ImmutableList<Layer>)ImmutableList.of((Object)new ScreenViewLayer(this.myScreenView)));
        } else {
            this.myScreenView = new ScreenView(this, ScreenView.ScreenViewType.NORMAL, this.myModel);
            this.setLayers(NlDesignSurface.getScreenLayers(this, this.myScreenView));
        }
        this.updateErrorDisplay();
        this.getLayeredPane().setPreferredSize(this.myScreenView.getPreferredSize());
        this.layoutContent();
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        if (this.myScreenMode == ScreenMode.BOTH && this.myScreenView != null && this.myBlueprintView != null) {
            if (this.isStackVertically()) {
                dimension.setSize(this.myScreenView.getSize().getWidth(), this.myScreenView.getSize().getHeight() + this.myBlueprintView.getSize().getHeight());
            } else {
                dimension.setSize(this.myScreenView.getSize().getWidth() + this.myBlueprintView.getSize().getWidth(), this.myScreenView.getSize().getHeight());
            }
        } else if (this.getCurrentSceneView() != null) {
            dimension.setSize(this.getCurrentSceneView().getSize().getWidth(), this.getCurrentSceneView().getSize().getHeight());
        }
        return dimension;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(120, 120);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        assert (this.myScreenView != null);
        Dimension preferredSize = this.myScreenView.getPreferredSize();
        int requiredWidth = preferredSize.width;
        int requiredHeight = preferredSize.height;
        if (this.myScreenMode == ScreenMode.BOTH) {
            if (NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                requiredHeight *= 2;
                requiredHeight += 10;
            } else {
                requiredWidth *= 2;
                requiredWidth += 10;
            }
        }
        return new Dimension(requiredWidth, requiredHeight);
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        ViewEditor editor = this.getViewEditor();
        if (handler != null && editor != null) {
            handler.onActivateInComponentTree(editor, component2);
        }
        super.notifyComponentActivate(component2);
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        ViewEditor editor = this.getViewEditor();
        if (handler != null && editor != null) {
            handler.onActivateInDesignSurface(editor, component2, x, y);
        }
        super.notifyComponentActivate(component2, x, y);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    private void setPanZoomPanel(@Nullable PanZoomPanel panZoomPanel) {
        this.myPanZoomPanel = new WeakReference<PanZoomPanel>(panZoomPanel);
    }

    @Nullable
    public PanZoomPanel getPanZoomPanel() {
        return (PanZoomPanel)this.myPanZoomPanel.get();
    }

    private void showPanZoomPanelIfRequired() {
        if (PanZoomPanel.isPropertyComponentOpen()) {
            this.setPanZoomPanelVisible(true);
        }
    }

    public void setPanZoomPanelVisible(boolean show) {
        PanZoomPanel panel = (PanZoomPanel)this.myPanZoomPanel.get();
        if (show) {
            if (panel == null) {
                panel = new PanZoomPanel(this);
            }
            this.setPanZoomPanel(panel);
            if (this.isShowing()) {
                panel.showPopup();
            } else {
                final PanZoomPanel finalPanel = panel;
                ComponentAdapter adapter = new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        finalPanel.showPopup();
                        NlDesignSurface.this.removeComponentListener(this);
                    }
                };
                this.addComponentListener(adapter);
            }
        } else if (panel != null) {
            panel.closePopup();
        }
    }

    public void updateErrorDisplay() {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result;
                RenderResult renderResult = result = NlDesignSurface.this.getCurrentSceneView() != null ? NlDesignSurface.this.getCurrentSceneView().getResult() : null;
                if (result == null) {
                    return;
                }
                BuildMode gradleBuildMode = BuildSettings.getInstance(NlDesignSurface.this.getProject()).getBuildMode();
                RenderErrorModel model = gradleBuildMode != null && result.getLogger().hasErrors() ? RenderErrorModel.STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(result, DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                NlDesignSurface.this.getIssueModel().setRenderErrorModel(model);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    protected void modelRendered(@NotNull NlModel model) {
        if (this.getCurrentSceneView() != null) {
            this.updateErrorDisplay();
        }
        super.modelRendered(model);
    }

    @Override
    protected boolean useSmallProgressIcon() {
        return this.getCurrentSceneView() != null && this.getCurrentSceneView().getResult() != null;
    }

    @Override
    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        return NlDesignSurface.createComponent(tag, this.getModel());
    }

    @NotNull
    public static NlComponent createComponent(@NotNull XmlTag tag, @NotNull NlModel model) {
        NlComponent result = DesignSurface.createComponent(tag, model);
        NlComponentHelper.INSTANCE.registerComponent(result);
        return result;
    }

    @Override
    protected double getMinScale() {
        return Math.min(this.getFitScale(false), 1.0);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        ViewGroupHandler viewGroupHandler;
        ScreenView screenView = (ScreenView)view;
        Dimension size = screenView.getSize();
        Rectangle resizeZone = new Rectangle(view.getX() + size.width, screenView.getY() + size.height, 48, 48);
        if (resizeZone.contains(mouseX, mouseY)) {
            return new CanvasResizeInteraction(this);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component2 = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component2 == null) {
            if (!selectionModel.isEmpty()) {
                component2 = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        ViewGroupHandler viewGroupHandler2 = viewGroupHandler = component2 != null ? NlComponentHelperKt.getViewGroupHandler(component2) : null;
        if (viewGroupHandler == null) {
            return null;
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            NlComponent parent;
            NlComponent primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
            if (parent != null) {
                ViewGroupHandler handler;
                int ax = Coordinates.getAndroidX(screenView, mouseX);
                int ay = Coordinates.getAndroidY(screenView, mouseY);
                if (NlComponentHelperKt.containsX(primary, ax) && NlComponentHelperKt.containsY(primary, ay) && (handler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                    interaction = handler.createInteraction(screenView, primary);
                }
            }
        }
        if (interaction == null) {
            interaction = viewGroupHandler.createInteraction(screenView, component2);
        }
        return interaction;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        List<Object> dragged;
        NlComponent primaryNlComponent;
        NlComponent nlComponent = primaryNlComponent = primary != null ? primary.getNlComponent() : null;
        if (this.getSelectionModel().isSelected(draggedSceneComponent.getNlComponent())) {
            dragged = Lists.newArrayList();
            if (primary != null) {
                if (primary.getParent() == null) {
                    primaryNlComponent = null;
                } else {
                    dragged.add(primaryNlComponent);
                }
            }
            for (NlComponent selected : this.getSelectionModel().getSelection()) {
                if (selected.isRoot() || selected == primaryNlComponent) continue;
                dragged.add(selected);
            }
        } else {
            dragged = Collections.singletonList(primaryNlComponent);
        }
        return new DragDropInteraction(this, (List<NlComponent>)dragged);
    }

    private class MyBottomLayer
    extends Layer {
        private boolean myPaintedFrame;

        private MyBottomLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            Composite oldComposite = g2d.getComposite();
            assert (NlDesignSurface.this.myScreenView != null);
            RenderResult result = NlDesignSurface.this.myScreenView.getResult();
            this.myPaintedFrame = false;
            if (NlDesignSurface.this.myDeviceFrames && result != null && result.hasImage()) {
                Configuration configuration = NlDesignSurface.this.myScreenView.getConfiguration();
                Device device = configuration.getDevice();
                State deviceState = configuration.getDeviceState();
                DeviceArtPainter painter = DeviceArtPainter.getInstance();
                if (device != null && painter.hasDeviceFrame(device) && deviceState != null) {
                    this.myPaintedFrame = true;
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
                    painter.paintFrame(g2d, device, deviceState.getOrientation(), true, NlDesignSurface.this.myScreenX, NlDesignSurface.this.myScreenY, (int)(NlDesignSurface.this.myScale * (double)result.getRenderedImage().getHeight()));
                }
            }
            g2d.setComposite(oldComposite);
            if (!NlDesignSurface.this.getLayoutType().isSupportedByDesigner()) {
                return;
            }
            if (!this.myPaintedFrame) {
                this.paintBorder(g2d);
            }
        }

        private void paintBorder(Graphics2D g2d) {
            if (NlDesignSurface.this.myScreenView == null) {
                return;
            }
            Shape screenShape = NlDesignSurface.this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g2d.draw(screenShape);
                return;
            }
            ScreenView.BorderPainter.paint(g2d, NlDesignSurface.this.myScreenView);
            if (NlDesignSurface.this.myScreenMode == ScreenMode.BOTH) {
                ScreenView.BorderPainter.paint(g2d, NlDesignSurface.this.myBlueprintView);
            }
        }
    }

    public static enum ScreenMode {
        SCREEN_ONLY,
        BLUEPRINT_ONLY,
        BOTH;

        @NotNull
        static final ScreenMode DEFAULT_SCREEN_MODE;
        static final String SCREEN_MODE_PROPERTY = "NlScreenMode";

        @NotNull
        public ScreenMode next() {
            ScreenMode[] values = ScreenMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        @NotNull
        public static ScreenMode loadPreferredMode() {
            String modeName = PropertiesComponent.getInstance().getValue(SCREEN_MODE_PROPERTY, DEFAULT_SCREEN_MODE.name());
            try {
                return ScreenMode.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                Logger.getInstance(NlDesignSurface.class).warn("The mode " + modeName + " is not recognized, use default mode " + SCREEN_MODE_PROPERTY + " instead");
                return DEFAULT_SCREEN_MODE;
            }
        }

        public static void savePreferredMode(@NotNull ScreenMode mode) {
            PropertiesComponent.getInstance().setValue(SCREEN_MODE_PROPERTY, mode.name());
        }

        static {
            DEFAULT_SCREEN_MODE = BOTH;
        }
    }
}

