/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class SelectionLayer
extends Layer {
    private final ScreenView myScreenView;

    public SelectionLayer(@NotNull ScreenView screenView) {
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        SelectionModel model = this.myScreenView.getSelectionModel();
        for (NlComponent component2 : model.getSelection()) {
            if (component2.isRoot() || !component2.isShowing() || SelectionLayer.parentHandlingSelection(component2)) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component2));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component2));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component2));
            int h = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getH(component2));
            NlGraphics.drawRect(NlDrawingStyle.SELECTION, gc, x, y, w + 1, h + 1);
            SelectionHandles handles = model.getHandles(component2);
            for (SelectionHandle handle : handles) {
                int sx = Coordinates.getSwingX(this.myScreenView, handle.getCenterX());
                int sy = Coordinates.getSwingY(this.myScreenView, handle.getCenterY());
                NlGraphics.drawFilledRect(NlDrawingStyle.SELECTION, gc, sx - 4, sy - 4, 8, 8);
            }
        }
    }

    private static boolean parentHandlingSelection(@NotNull NlComponent component2) {
        ViewGroupHandler viewGroupHandler;
        NlComponent parent = component2.getParent();
        if (parent == null) {
            return false;
        }
        ViewInfo view = NlComponentHelperKt.getViewInfo(parent);
        if (view == null) {
            return false;
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(parent);
        return handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting();
    }
}

