/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningLayer
extends Layer {
    public static final int PADDING = 5;
    private final ScreenView myScreenView;
    private final List<NlComponent> myAnnotatedComponents = Lists.newArrayList();

    public WarningLayer(@NotNull ScreenView screenView) {
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (!AndroidEditorSettings.getInstance().getGlobalState().isShowLint()) {
            return;
        }
        this.myAnnotatedComponents.clear();
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return;
        }
        for (NlComponent component2 : lintModel.getComponentsWithIssues()) {
            Icon icon;
            if (!component2.isShowing() || (icon = lintModel.getIssueIcon(component2)) == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component2));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component2));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component2));
            icon.paintIcon(null, gc, x + w - icon.getIconWidth() - 5, y + 5);
            this.myAnnotatedComponents.add(component2);
        }
    }

    @Override
    @Nullable
    public String getTooltip(int mx, int my) {
        LintAnnotationsModel lintModel = this.myScreenView.getModel().getLintAnnotationsModel();
        if (lintModel == null) {
            return null;
        }
        for (NlComponent component2 : this.myAnnotatedComponents) {
            Icon icon = lintModel.getIssueIcon(component2);
            if (icon == null) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component2));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component2));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component2));
            if (mx <= x + w - icon.getIconWidth() - 5 || mx >= x + w - 5 || my <= y + 5 || my >= y + 5 + icon.getIconHeight()) continue;
            return lintModel.getIssueMessage(component2);
        }
        return null;
    }
}

