/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Downloader;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SimpleRepositorySource;
import com.android.repository.impl.sources.LocalSourceProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.AndroidSdkUpdaterPlugin;
import com.android.tools.idea.updater.configure.EditSourceDialog;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.icons.AllIcons;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SourcesTableModel
extends ListTableModel<Row>
implements EditableModel {
    private Set<RepositorySource> myInitialItems;
    private Runnable myRefreshCallback;
    private Runnable myLoadingStartedCallback;
    private Runnable myLoadingFinishedCallback;
    private static final com.android.repository.api.ProgressIndicator myLogger = new StudioLoggerProgressIndicator(SourcesTableModel.class);
    private SdkUpdaterConfigurable myConfigurable;

    SourcesTableModel(@NotNull Runnable startLoading, @NotNull Runnable finishLoading) {
        super(new ColumnInfo[0]);
        this.setColumnInfos(new ColumnInfo[]{new ColumnInfo<Row, Boolean>("Enabled"){

            @Nullable
            public Boolean valueOf(Row row) {
                return row.mySource.isEnabled();
            }

            public int getWidth(JTable table) {
                return 60;
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(Row row) {
                return SourcesTableModel.this.isEditable() && Strings.isNullOrEmpty((String)row.mySource.getFetchError());
            }

            public void setValue(Row row, Boolean value) {
                row.mySource.setEnabled(value.booleanValue());
                SourcesTableModel.this.myRefreshCallback.run();
            }

            @Nullable
            public TableCellRenderer getRenderer(final Row row) {
                String error = row.mySource.getFetchError();
                if (!Strings.isNullOrEmpty((String)error)) {
                    return new IconTableCellRenderer<Boolean>(){

                        @Nullable
                        protected Icon getIcon(@NotNull Boolean value, JTable table, int row2) {
                            return AllIcons.General.Error;
                        }

                        public String getText() {
                            return null;
                        }

                        public String getToolTipText() {
                            return row.mySource.getFetchError();
                        }

                        public int getHorizontalAlignment() {
                            return 0;
                        }
                    };
                }
                return super.getRenderer((Object)row);
            }
        }, new ColumnInfo<Row, String>("Name"){

            @Nullable
            public String valueOf(Row r) {
                return r.mySource.getDisplayName();
            }
        }, new ColumnInfo<Row, String>("URL"){

            @Nullable
            public String valueOf(Row r) {
                return r.mySource.getUrl();
            }
        }});
        this.myLoadingFinishedCallback = finishLoading;
        this.myLoadingStartedCallback = startLoading;
    }

    public void setAllEnabled(boolean enabled) {
        for (Row r : this.getItems()) {
            r.mySource.setEnabled(enabled);
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        this.myRefreshCallback.run();
    }

    public void setConfigurable(SdkUpdaterConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    private void refreshUi() {
        this.myLoadingStartedCallback.run();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final ArrayList items = Lists.newArrayList();
                final HashSet initial = Sets.newHashSet();
                for (RepositorySource source : SourcesTableModel.this.myConfigurable.getRepoManager().getSources((Downloader)new StudioDownloader(), myLogger, false)) {
                    items.add(new Row(source));
                    initial.add(source);
                }
                Collections.sort(items);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (SourcesTableModel.this.myInitialItems == null) {
                            SourcesTableModel.this.myInitialItems = initial;
                        }
                        SourcesTableModel.this.setItems(items);
                    }
                });
                SourcesTableModel.this.myLoadingFinishedCallback.run();
            }
        });
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SourcesTableModel.this.myRefreshCallback.run();
            }
        }, ModalityState.any());
    }

    public void editRow(int index) {
        Row r = (Row)this.getRowValue(index);
        EditSourceDialog input = this.showEditDialog(r.mySource);
        if (input.isOK()) {
            this.removeRow(index);
            this.createSource(input.getUrl(), input.getUiName(), input.getCredentials());
        }
    }

    public void addRow() {
        EditSourceDialog input = this.showEditDialog(null);
        if (input.isOK()) {
            this.createSource(input.getUrl(), input.getUiName(), input.getCredentials());
        }
    }

    @NotNull
    private EditSourceDialog showEditDialog(@Nullable RepositorySource source) {
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        EditSourceDialog input = new EditSourceDialog(userSourceProvider, source);
        input.show();
        return input;
    }

    private void createSource(@NotNull String url, @Nullable String uiName, @Nullable Credentials credentials) {
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        SimpleRepositorySource newSource = new SimpleRepositorySource(url, uiName, true, (Collection)ImmutableList.of((Object)AndroidSdkHandler.getAddonModule(), (Object)AndroidSdkHandler.getSysImgModule(), (Object)RepoManager.getCommonModule()), userSourceProvider);
        userSourceProvider.addSource((RepositorySource)newSource);
        PasswordSafe.getInstance().set(new CredentialAttributes(AndroidSdkUpdaterPlugin.getCredentialServiceName(url)), credentials);
        try {
            PasswordSafe.getInstance().set(new CredentialAttributes(AndroidSdkUpdaterPlugin.getCredentialServiceName(new URL(url).getHost())), credentials);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        this.refreshUi();
    }

    public void removeRow(int idx) {
        RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
        assert (userSourceProvider != null);
        userSourceProvider.removeSource(((Row)this.getRowValue((int)idx)).mySource);
        this.refreshUi();
    }

    public void exchangeRows(int oldIndex, int newIndex) {
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public boolean isEditable(int row) {
        return this.isEditable() && ((Row)this.getRowValue((int)row)).mySource.getProvider().isModifiable();
    }

    public void reset() {
        if (!this.isSourcesModified()) {
            if (this.myInitialItems == null) {
                this.refreshUi();
            }
            return;
        }
        this.myConfigurable.getRepoManager().getSources((Downloader)new StudioDownloader(), myLogger, true);
        this.myInitialItems = null;
        this.refreshUi();
    }

    public boolean isSourcesModified() {
        if (this.myInitialItems == null) {
            return false;
        }
        if (this.getItems().size() != this.myInitialItems.size()) {
            return true;
        }
        for (Row row : this.getItems()) {
            if (row.isModified()) {
                return true;
            }
            if (this.myInitialItems.contains(row.mySource)) continue;
            return true;
        }
        return false;
    }

    public void save(@NotNull ProgressIndicator progress) {
        if (this.isSourcesModified()) {
            RepositorySourceProvider userSourceProvider = this.getUserSourceProvider();
            assert (userSourceProvider != null);
            userSourceProvider.save((com.android.repository.api.ProgressIndicator)new RepoProgressIndicatorAdapter(progress));
            this.reset();
        }
    }

    @Nullable
    private RepositorySourceProvider getUserSourceProvider() {
        return this.myConfigurable.getSdkHandler().getUserSourceProvider(myLogger);
    }

    public void setRefreshCallback(@NotNull Runnable refreshCallback) {
        this.myRefreshCallback = refreshCallback;
    }

    public boolean isEditable() {
        return this.getUserSourceProvider() != null;
    }

    protected class Row
    implements SdkUpdaterConfigPanel.MultiStateRow,
    Comparable<Row> {
        RepositorySource mySource;
        boolean myOriginalEnabled;
        String myOriginalName;

        public Row(RepositorySource source) {
            this.mySource = source;
            this.myOriginalEnabled = this.mySource.isEnabled();
            this.myOriginalName = this.mySource.getDisplayName();
        }

        @Override
        public void cycleState() {
            if (SourcesTableModel.this.isEditable(SourcesTableModel.this.indexOf(this))) {
                this.mySource.setEnabled(!this.mySource.isEnabled());
            }
        }

        public boolean isModified() {
            return this.myOriginalEnabled != this.mySource.isEnabled() || !Objects.equal((Object)this.myOriginalName, (Object)this.mySource.getDisplayName());
        }

        @Override
        public int compareTo(Row o) {
            boolean isLocal = this.mySource.getProvider() instanceof LocalSourceProvider;
            if (isLocal != o.mySource.getProvider() instanceof LocalSourceProvider) {
                return isLocal ? -1 : 1;
            }
            if (this.myOriginalName == null || o.myOriginalName == null) {
                return this.myOriginalName == null ? (o.myOriginalName == null ? 0 : 1) : -1;
            }
            return this.myOriginalName.compareTo(o.myOriginalName);
        }
    }
}

