/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.MultiVersionTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.updater.configure.VersionColumnInfo;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class ToolComponentsPanel {
    private static final Set<String> MULTI_VERSION_PREFIXES = ImmutableSet.of((Object)"build-tools", (Object)"lldb", (Object)"cmake", (Object)String.join((CharSequence)String.valueOf(';'), "extras", "android", "gapid"));
    private TreeTableView myToolsSummaryTable;
    private JCheckBox myToolsDetailsCheckbox;
    private JPanel myToolsPanel;
    private TreeTableView myToolsDetailTable;
    private JPanel myToolsLoadingPanel;
    private AsyncProcessIcon myToolsLoadingIcon;
    private JPanel myRootPanel;
    private final Set<UpdatablePackage> myToolsPackages;
    private final Multimap<String, UpdatablePackage> myMultiVersionPackages;
    private final Multimap<String, UpdatablePackage> myMavenPackages;
    private UpdaterTreeNode myToolsDetailsRootNode;
    private UpdaterTreeNode myToolsSummaryRootNode;
    Set<PackageNodeModel> myStates;
    private boolean myModified;
    private final ChangeListener myModificationListener;
    private SdkUpdaterConfigurable myConfigurable;

    public ToolComponentsPanel() {
        this.$$$setupUI$$$();
        this.myToolsPackages = Sets.newTreeSet((Comparator)new Comparator<UpdatablePackage>(){

            @Override
            public int compare(UpdatablePackage o1, UpdatablePackage o2) {
                return ComparisonChain.start().compare((Comparable)((Object)o1.getRepresentative().getDisplayName()), (Comparable)((Object)o2.getRepresentative().getDisplayName())).compare((Comparable)((Object)o1.getRepresentative().getPath()), (Comparable)((Object)o2.getRepresentative().getPath())).result();
            }
        });
        this.myMultiVersionPackages = HashMultimap.create();
        this.myMavenPackages = HashMultimap.create();
        this.myStates = Sets.newHashSet();
        this.myModified = false;
        this.myModificationListener = e -> this.refreshModified();
        this.myToolsDetailsCheckbox.addActionListener(e -> this.updateToolsTable());
    }

    private void updateToolsTable() {
        ((CardLayout)this.myToolsPanel.getLayout()).show(this.myToolsPanel, this.myToolsDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updateToolsItems() {
        UpdaterTreeNode summaryNode;
        boolean isMaven;
        this.myToolsDetailsRootNode.removeAllChildren();
        this.myToolsSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        ParentTreeNode mavenSummaryParent = new ParentTreeNode("Support Repository");
        ParentTreeNode mavenDetailsParent = new ParentTreeNode("Support Repository");
        for (String prefix : this.myMultiVersionPackages.keySet()) {
            Collection versions = this.myMultiVersionPackages.get((Object)prefix);
            TreeSet<DetailsTreeNode> detailsNodes = new TreeSet<DetailsTreeNode>();
            isMaven = false;
            for (UpdatablePackage info : versions) {
                RepoPackage representative = info.getRepresentative();
                if (representative.getTypeDetails() instanceof DetailsTypes.MavenType) {
                    isMaven = true;
                }
                PackageNodeModel model = new PackageNodeModel(info);
                this.myStates.add(model);
                detailsNodes.add(new DetailsTreeNode(model, this.myModificationListener, this.myConfigurable));
            }
            summaryNode = new MultiVersionTreeNode(detailsNodes);
            if (isMaven) {
                mavenSummaryParent.add(summaryNode);
            } else {
                this.myToolsSummaryRootNode.add(summaryNode);
            }
            ParentTreeNode multiVersionParent = new ParentTreeNode(summaryNode.getDisplayName());
            detailsNodes.forEach(multiVersionParent::add);
            if (isMaven) {
                mavenDetailsParent.add(multiVersionParent);
                continue;
            }
            this.myToolsDetailsRootNode.add(multiVersionParent);
        }
        for (UpdatablePackage info : this.myToolsPackages) {
            PackageNodeModel holder = new PackageNodeModel(info);
            this.myStates.add(holder);
            DetailsTreeNode node = new DetailsTreeNode(holder, this.myModificationListener, this.myConfigurable);
            isMaven = info.getPath().endsWith(";m2repository");
            if (isMaven) {
                mavenDetailsParent.add(node);
            } else {
                this.myToolsDetailsRootNode.add(node);
            }
            if (info.getRepresentative().obsolete()) continue;
            summaryNode = new DetailsTreeNode(holder, this.myModificationListener, this.myConfigurable);
            if (isMaven) {
                mavenSummaryParent.add(summaryNode);
                continue;
            }
            this.myToolsSummaryRootNode.add(summaryNode);
        }
        if (mavenSummaryParent.getChildCount() > 0) {
            this.myToolsSummaryRootNode.add(mavenSummaryParent);
            this.myToolsDetailsRootNode.add(mavenDetailsParent);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myToolsSummaryTable);
        this.myToolsDetailTable.updateUI();
        this.myToolsSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myToolsDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myToolsSummaryTable.getTree());
    }

    public void setPackages(@NotNull Set<UpdatablePackage> toolsPackages) {
        this.myMultiVersionPackages.clear();
        this.myToolsPackages.clear();
        for (UpdatablePackage p : toolsPackages) {
            String prefix = p.getRepresentative().getPath();
            int lastSegmentIndex = prefix.lastIndexOf(59);
            boolean found = false;
            if (lastSegmentIndex > 0) {
                if ((prefix = prefix.substring(0, lastSegmentIndex)).equals("patcher")) continue;
                if (MULTI_VERSION_PREFIXES.contains(prefix) || p.getRepresentative().getTypeDetails() instanceof DetailsTypes.MavenType) {
                    this.myMultiVersionPackages.put((Object)prefix, (Object)p);
                    found = true;
                }
            }
            if (found) continue;
            this.myToolsPackages.add(p);
        }
        this.updateToolsItems();
    }

    public void startLoading() {
        this.myToolsPackages.clear();
        this.myMultiVersionPackages.clear();
        this.myMavenPackages.clear();
        this.myToolsLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updateToolsItems();
        this.myToolsLoadingPanel.setVisible(false);
    }

    public void reset() {
        Enumeration<TreeNode> children = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)children.nextElement();
            node.resetState();
        }
        this.refreshModified();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items = this.myToolsDetailsRootNode.breadthFirstEnumeration();
        while (items.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)items.nextElement();
            if (node.getInitialState() == node.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    private void createUIComponents() {
        this.myToolsLoadingIcon = new AsyncProcessIcon("Loading...");
        this.myToolsSummaryRootNode = new RootNode();
        this.myToolsDetailsRootNode = new RootNode();
        UpdaterTreeNode.Renderer renderer = new UpdaterTreeNode.Renderer();
        ColumnInfo[] toolsSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsSummaryRootNode, toolsSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsSummaryTable, renderer, this.myModificationListener);
        ColumnInfo[] toolsDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new VersionColumnInfo(), new StatusColumnInfo()};
        this.myToolsDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myToolsDetailsRootNode, toolsDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myToolsDetailTable, renderer, this.myModificationListener);
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>Below are the available SDK developer tools. Once installed, Android Studio will automatically check for updates. Check \"show package details\" to display available versions of an SDK Tool.</html>");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        this.myToolsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "summary");
        TreeTableView treeTableView = this.myToolsSummaryTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, "details");
        TreeTableView treeTableView2 = this.myToolsDetailTable;
        jBScrollPane2.setViewportView((Component)treeTableView2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        this.myToolsDetailsCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show Package Details");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 4, 0, 7, 0, null, null, null));
        this.myToolsLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Looking for updates...");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myToolsLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

