/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ListenerCollection<T> {
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Executor myExecutor;
    private final Set<T> myListenersSet = new HashSet<T>();
    private ImmutableSet<T> myListenerSetCopy;

    private ListenerCollection(@NotNull Executor executor) {
        this.myExecutor = executor;
    }

    @NotNull
    public static <T> ListenerCollection<T> createWithDirectExecutor() {
        return ListenerCollection.createWithExecutor(MoreExecutors.directExecutor());
    }

    @NotNull
    public static <T> ListenerCollection<T> createWithExecutor(@NotNull Executor executor) {
        return new ListenerCollection<T>(executor);
    }

    public boolean add(@NotNull T listener) {
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = null;
            boolean bl = this.myListenersSet.add(listener);
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public boolean remove(@NotNull T listener) {
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = null;
            boolean bl = this.myListenersSet.remove(listener);
            return bl;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.myListenerSetCopy = ImmutableSet.of();
            this.myListenersSet.clear();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> forEach(@NotNull Consumer<T> runOnListener) {
        ImmutableSet listeners;
        SettableFuture future = SettableFuture.create();
        this.myLock.readLock().lock();
        if (this.myListenerSetCopy == null) {
            this.myLock.readLock().unlock();
            this.myLock.writeLock().lock();
            try {
                this.myListenerSetCopy = ImmutableSet.copyOf(this.myListenersSet);
                this.myLock.readLock().lock();
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }
        try {
            listeners = this.myListenerSetCopy;
        }
        finally {
            this.myLock.readLock().unlock();
        }
        if (listeners.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        this.myExecutor.execute(() -> {
            listeners.forEach(runOnListener);
            future.set(null);
        });
        return future;
    }
}

