/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComponentCategory
extends ComponentTreeNode {
    @NotNull
    private final String myName;
    @NotNull
    private final Collection<ComponentTreeNode> myComponents;

    public ComponentCategory(@NotNull String name, @NotNull String description, ComponentTreeNode ... components) {
        this(name, description, Arrays.asList(components));
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        for (ComponentTreeNode component2 : this.myComponents) {
            component2.init(progressStep);
        }
    }

    public ComponentCategory(@NotNull String name, @NotNull String description, @NotNull Collection<ComponentTreeNode> components) {
        super(description);
        this.myName = name;
        this.myComponents = components;
    }

    @Override
    public String getLabel() {
        return this.myName;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component2 : this.myComponents) {
            builder.addAll(component2.getChildrenToInstall());
        }
        return builder.build();
    }

    @Override
    public void updateState(@NotNull AndroidSdkHandler sdkHandler) {
        for (ComponentTreeNode component2 : this.myComponents) {
            component2.updateState(sdkHandler);
        }
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentTreeNode component2 : this.myComponents) {
            builder.addAll(component2.createSteps());
        }
        return builder.build();
    }

    @Override
    public boolean isChecked() {
        for (ComponentTreeNode component2 : this.myComponents) {
            if (component2.isChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean componentStateChanged(@NotNull Set<ScopedStateStore.Key> modified) {
        for (ComponentTreeNode component2 : this.myComponents) {
            if (!component2.componentStateChanged(modified)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return this.myComponents;
    }

    @Override
    public boolean isOptional() {
        for (ComponentTreeNode component2 : this.myComponents) {
            if (!component2.isOptional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        for (ComponentTreeNode component2 : this.myComponents) {
            component2.toggle(isSelected);
        }
    }
}

