/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstallOperation<Return, Argument> {
    protected final InstallContext myContext;
    private final double myProgressRatio;

    protected InstallOperation(InstallContext context, double progressRatio) {
        this.myContext = context;
        this.myProgressRatio = progressRatio;
    }

    public static <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context, @NotNull Function<Argument, Return> function, double progressShare) {
        return new FunctionWrapper<Return, Argument>(context, function, progressShare);
    }

    @NotNull
    protected abstract Return perform(@NotNull ProgressIndicator var1, @NotNull Argument var2) throws WizardException, InstallationCancelledException;

    @NotNull
    public final Return execute(final @NotNull Argument argument) throws WizardException, InstallationCancelledException {
        this.myContext.checkCanceled();
        if (this.myProgressRatio == 0.0) {
            return this.perform((ProgressIndicator)new EmptyProgressIndicator(), argument);
        }
        try {
            return (Return)this.myContext.run(new ThrowableComputable<Return, Exception>(){

                @Nullable
                public Return compute() throws Exception {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator == null) {
                        indicator = new EmptyProgressIndicator();
                    }
                    return InstallOperation.this.perform(indicator, argument);
                }
            }, this.myProgressRatio);
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, WizardException.class, InstallationCancelledException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected final void promptToRetry(final @NotNull String prompt, @NotNull String failureDescription, @Nullable Exception e) throws WizardException {
        final AtomicBoolean response = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int i = Messages.showYesNoDialog(null, (String)prompt, (String)"Android Studio Setup", (String)"Retry", (String)"Cancel", (Icon)Messages.getErrorIcon());
                response.set(i == 0);
            }
        }, application.getAnyModalityState());
        if (!response.get()) {
            Throwables.propagateIfInstanceOf((Throwable)e, WizardException.class);
            throw new WizardException(failureDescription, e);
        }
        this.myContext.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    public abstract void cleanup(@NotNull Return var1);

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull InstallOperation<FinalResult, Return> next) {
        return new OperationChain(this, next);
    }

    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull Function<Return, FinalResult> next) {
        return this.then(InstallOperation.wrap(this.myContext, next, 0.0));
    }

    private static class FunctionWrapper<Return, Argument>
    extends InstallOperation<Return, Argument> {
        @NotNull
        private final Function<Argument, Return> myRunnable;

        public FunctionWrapper(@NotNull InstallContext context, @NotNull Function<Argument, Return> runnable, double progressShare) {
            super(context, progressShare);
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Return perform(@NotNull ProgressIndicator indicator, @NotNull Argument arg) throws WizardException {
            indicator.start();
            try {
                Object value = this.myRunnable.apply(arg);
                assert (value != null);
                Object object = value;
                return (Return)object;
            }
            finally {
                indicator.setFraction(1.0);
            }
        }

        @Override
        public void cleanup(@NotNull Return result) {
        }
    }

    private static class OperationChain<FinalResult, Argument, Return>
    extends InstallOperation<FinalResult, Argument> {
        private final InstallOperation<Return, Argument> myFirst;
        private final InstallOperation<FinalResult, Return> mySecond;

        public OperationChain(InstallOperation<Return, Argument> first, InstallOperation<FinalResult, Return> second) {
            super(first.myContext, 0.0);
            this.myFirst = first;
            this.mySecond = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected FinalResult perform(@NotNull ProgressIndicator indicator, @NotNull Argument argument) throws WizardException, InstallationCancelledException {
            Return execute = this.myFirst.execute(argument);
            try {
                FinalResult FinalResult = this.mySecond.execute(execute);
                return FinalResult;
            }
            finally {
                this.myFirst.cleanup(execute);
            }
        }

        @Override
        public void cleanup(@NotNull FinalResult result) {
            this.mySecond.cleanup(result);
        }
    }
}

