/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.whatsnew;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.TipOfTheDayManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ResourceUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNew
implements StartupActivity,
DumbAware {
    private static final String RESOURCE_DIR = "whatsNew";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActivity(@NotNull Project project) {
        WhatsNewService service = (WhatsNewService)ServiceManager.getService(WhatsNewService.class);
        if (service == null || !IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        WhatsNewData data = service.getState();
        if (AndroidPlugin.isGuiTestingMode() && !data.myIsUnderTest) {
            return;
        }
        Revision applicationRevision = Revision.parseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        URL resourceUrl = ResourceUtil.getResource(WhatsNew.class, (String)RESOURCE_DIR, (String)"");
        if (resourceUrl == null) {
            return;
        }
        String messagePath = this.getMessageToShow(data, applicationRevision, resourceUrl);
        if (messagePath != null) {
            try {
                WhatsNew.disableTipOfTheDay();
                String text = WhatsNew.getAccessibleText(messagePath, resourceUrl);
                InputStream stream = WhatsNew.class.getResourceAsStream(messagePath);
                if (stream == null) {
                    stream = new FileInputStream(messagePath);
                }
                try {
                    ImageIcon image = new ImageIcon(ImageIO.read(stream));
                    ApplicationManager.getApplication().invokeLater(() -> ((WhatsNewDialog)new WhatsNewDialog(project, image, text)).show());
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private static String getAccessibleText(@NotNull String imagePath, @NotNull URL resourceUrl) {
        Path image;
        block4: {
            String string;
            String base = FileUtil.getNameWithoutExtension((String)imagePath);
            image = null;
            try {
                image = WhatsNew.toPath(resourceUrl).resolve(imagePath);
                Path textPath = image.getParent().resolve(base + ".txt");
                if (!Files.exists(textPath, new LinkOption[0])) break block4;
                string = new String(Files.readAllBytes(textPath), Charsets.UTF_8);
            }
            catch (IOException | URISyntaxException exception) {
                WhatsNew.closeFilesystem(image);
                catch (Throwable throwable) {
                    WhatsNew.closeFilesystem(image);
                    throw throwable;
                }
            }
            WhatsNew.closeFilesystem(image);
            return string;
        }
        WhatsNew.closeFilesystem(image);
        return null;
    }

    private static void closeFilesystem(@Nullable Path path) {
        if (path != null) {
            try {
                path.getFileSystem().close();
            }
            catch (IOException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
    }

    private static void disableTipOfTheDay() {
        TipOfTheDayManager tips = (TipOfTheDayManager)Extensions.findExtension((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY, TipOfTheDayManager.class);
        try {
            Field flag = TipOfTheDayManager.class.getDeclaredField("myVeryFirstProjectOpening");
            flag.setAccessible(true);
            flag.setBoolean(tips, false);
            flag.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    String getMessageToShow(@NotNull WhatsNewData data, @NotNull Revision applicationRevision, @NotNull URL resourceDir) {
        String seenRevisionStr = data.myRevision;
        Revision seenRevision = null;
        if (seenRevisionStr != null) {
            try {
                seenRevision = Revision.parseRevision((String)seenRevisionStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (seenRevision == null || applicationRevision.compareTo(seenRevision, Revision.PreviewComparison.ASCENDING) > 0) {
            data.myRevision = applicationRevision.toString();
            Path latestMessage = WhatsNew.getLatestMessage(resourceDir);
            if (latestMessage != null) {
                Revision latestMessageRevision = WhatsNew.toRevision(latestMessage);
                Revision truncatedLatestMessageRevision = new Revision(latestMessageRevision.getMajor(), latestMessageRevision.getMinor());
                Revision truncatedApplicationRevision = new Revision(applicationRevision.getMajor(), applicationRevision.getMinor());
                if (truncatedApplicationRevision.compareTo(truncatedLatestMessageRevision) == 0 && (seenRevision == null || seenRevision.compareTo(latestMessageRevision, Revision.PreviewComparison.ASCENDING) < 0)) {
                    return latestMessage.toString();
                }
            }
        }
        return null;
    }

    @NotNull
    private static Revision toRevision(@NotNull Path p) {
        String revisionStr = com.google.common.io.Files.getNameWithoutExtension((String)p.getFileName().toString());
        try {
            return Revision.parseRevision((String)revisionStr);
        }
        catch (RuntimeException exception) {
            return Revision.NOT_SPECIFIED;
        }
    }

    @Nullable
    private static Path getLatestMessage(@NotNull URL resourceDir) {
        Path dir = null;
        try {
            dir = WhatsNew.toPath(resourceDir);
            Path path = Files.list(dir).filter(p -> p.toString().endsWith(".png")).max((p1, p2) -> WhatsNew.toRevision(p1).compareTo(WhatsNew.toRevision(p2), Revision.PreviewComparison.ASCENDING)).orElse(null);
            return path;
        }
        catch (IOException | URISyntaxException exception) {
        }
        finally {
            WhatsNew.closeFilesystem(dir);
        }
        return null;
    }

    private static Path toPath(@NotNull URL resourceDir) throws URISyntaxException, IOException {
        Path dir = null;
        try {
            dir = Paths.get(resourceDir.toURI());
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        if (dir == null) {
            FileSystem filesystem = FileSystems.newFileSystem(resourceDir.toURI(), ImmutableMap.of());
            JarURLConnection connection = (JarURLConnection)resourceDir.openConnection();
            dir = filesystem.getPath(connection.getEntryName(), new String[0]);
        }
        return dir;
    }

    private static class WhatsNewDialog
    extends DialogWrapper {
        private final Icon myImage;
        private final String myText;

        public WhatsNewDialog(@NotNull Project project, @NotNull Icon image, @Nullable String text) {
            super(project, false);
            this.setModal(true);
            this.myImage = image;
            this.myText = text;
            this.setTitle("What's New");
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction()};
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBLabel label = new JBLabel(this.myImage);
            if (this.myText != null) {
                label.getAccessibleContext().setAccessibleDescription(this.myText);
            }
            return label;
        }
    }

    public static class WhatsNewData {
        @Tag(value="shownVersion")
        public String myRevision;
        @Transient
        public boolean myIsUnderTest = false;
    }

    @State(name="whatsNew", storages={@Storage(value="androidStudioFirstRun.xml")})
    public static class WhatsNewService
    implements PersistentStateComponent<WhatsNewData> {
        private WhatsNewData myData;

        @NotNull
        public WhatsNewData getState() {
            if (this.myData == null) {
                this.myData = new WhatsNewData();
            }
            return this.myData;
        }

        public void loadState(WhatsNewData state) {
            this.myData = state;
        }
    }
}

