/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardPath
implements ScopedStateStore.ScopedStoreListener,
AndroidStudioWizardPath {
    protected List<DynamicWizardStep> mySteps = Lists.newArrayList();
    protected DynamicWizard myWizard;
    protected int myCurrentStepIndex;
    protected DynamicWizardStep myCurrentStep;
    protected boolean myIsValid;
    protected ScopedStateStore myState = new ScopedStateStore(ScopedStateStore.Scope.PATH, null, this);
    @Nullable
    private MergingUpdateQueue myUpdateQueue;
    private boolean myUpdateInProgress;
    private boolean myIsInitialized = false;

    @Override
    public final void attachToWizard(@NotNull DynamicWizard wizard) {
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isUnitTestMode()) {
            application.assertIsDispatchThread();
        }
        this.myWizard = wizard;
        this.myUpdateQueue = wizard.getUpdateQueue();
        Map<String, Object> myCurrentValues = this.myState.flatten();
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.PATH, this.myWizard.getState(), this);
        for (String keyName : myCurrentValues.keySet()) {
            this.myState.put(this.myState.createKey(keyName, Object.class), myCurrentValues.get(keyName));
        }
        this.init();
        this.myIsInitialized = true;
    }

    @Override
    @Nullable
    public DynamicWizard getWizard() {
        return this.myWizard;
    }

    protected abstract void init();

    public final void addStep(@NotNull DynamicWizardStep step) {
        this.mySteps.add(step);
        step.attachToPath(this);
    }

    public final ScopedStateStore getState() {
        return this.myState;
    }

    public final void setState(@NotNull ScopedStateStore overrideState) {
        this.myState = overrideState;
    }

    @Override
    public final int getVisibleStepCount() {
        int sum = 0;
        for (DynamicWizardStep step : this.mySteps) {
            if (!step.isStepVisible()) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    @Nullable
    public final DynamicWizardStep getCurrentStep() {
        return this.myCurrentStep;
    }

    public List<DynamicWizardStep> getAllSteps() {
        return this.mySteps;
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        if (this.mySteps.isEmpty() || this.getVisibleStepCount() == 0) {
            return;
        }
        this.myCurrentStep = null;
        if (fromBeginning) {
            this.myCurrentStepIndex = -1;
            this.myCurrentStep = this.next();
        } else {
            this.myCurrentStepIndex = this.mySteps.size();
            this.myCurrentStep = this.previous();
        }
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.queue((Update)new PathUpdate());
        } else {
            this.update();
        }
    }

    private void update() {
        if (this.myIsInitialized && !this.myUpdateInProgress) {
            try {
                this.myUpdateInProgress = true;
                this.deriveValues(this.myState.getRecentUpdates());
                this.myIsValid = this.validate();
            }
            finally {
                this.myUpdateInProgress = false;
                this.updateButtons();
            }
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public boolean validate() {
        return true;
    }

    @Override
    public boolean canGoNext() {
        return (this.myCurrentStep == null || this.myCurrentStep.canGoNext()) && this.myIsValid;
    }

    @Override
    public boolean canGoPrevious() {
        return this.myCurrentStep == null || this.myCurrentStep.canGoPrevious();
    }

    @Override
    public final boolean hasNext() {
        if (this.myCurrentStepIndex >= this.mySteps.size() - 1) {
            return false;
        }
        for (int i = this.myCurrentStepIndex + 1; i < this.mySteps.size(); ++i) {
            if (!this.mySteps.get(i).isStepVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasPrevious() {
        if (this.myCurrentStepIndex == 0) {
            return false;
        }
        for (int i = this.myCurrentStepIndex - 1; i >= 0; --i) {
            if (!this.mySteps.get(i).isStepVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public final DynamicWizardStep next() {
        if (!(this.myCurrentStep == null || this.myCurrentStep.canGoNext() && this.myCurrentStep.commitStep())) {
            return this.myCurrentStep;
        }
        do {
            ++this.myCurrentStepIndex;
        } while (this.myCurrentStepIndex < this.mySteps.size() && !this.mySteps.get(this.myCurrentStepIndex).isStepVisible());
        if (this.myCurrentStepIndex < this.mySteps.size()) {
            this.myCurrentStep = this.mySteps.get(this.myCurrentStepIndex);
            this.myCurrentStep.onEnterStep();
            this.myCurrentStep.invokeUpdate(null);
            this.invokeUpdate(null);
        } else {
            this.myCurrentStep = null;
        }
        return this.myCurrentStep;
    }

    @Override
    public boolean readyToLeavePath() {
        return this.myCurrentStep == null || this.myCurrentStep.commitStep();
    }

    @Override
    @Nullable
    public final DynamicWizardStep previous() {
        if (this.myCurrentStep != null && !this.myCurrentStep.canGoPrevious()) {
            return this.myCurrentStep;
        }
        do {
            --this.myCurrentStepIndex;
        } while (this.myCurrentStepIndex >= 0 && !this.mySteps.get(this.myCurrentStepIndex).isStepVisible());
        if (this.myCurrentStepIndex >= 0) {
            this.myCurrentStep = this.mySteps.get(this.myCurrentStepIndex);
            this.myCurrentStep.onEnterStep();
            this.myCurrentStep.invokeUpdate(null);
            this.invokeUpdate(null);
        } else {
            this.myCurrentStep = null;
        }
        return this.myCurrentStep;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    @Override
    public boolean isPathRequired() {
        return true;
    }

    @Override
    public boolean canPerformFinishingActions() {
        return true;
    }

    @NotNull
    public abstract String getPathName();

    @Nullable
    protected final Project getProject() {
        return this.myWizard != null ? this.myWizard.getProject() : null;
    }

    @Nullable
    protected final Module getModule() {
        return this.myWizard != null ? this.myWizard.getModule() : null;
    }

    @Override
    public final void setErrorHtml(String errorMessage) {
        if (this.myCurrentStep != null) {
            this.myCurrentStep.setErrorHtml(errorMessage);
        }
    }

    protected final void updateButtons() {
        if (this.myWizard != null && this.myCurrentStep != null) {
            this.myWizard.updateButtons(this.myCurrentStep.canGoPrevious(), this.myCurrentStep.canGoNext(), true, !this.hasNext() && this.myCurrentStep.canGoNext());
        }
    }

    @Override
    public void updateCurrentStep() {
        if (this.getCurrentStep() != null) {
            this.getCurrentStep().invokeUpdate(null);
        }
    }

    @Override
    public boolean containsStep(@NotNull String stepName, boolean visibleOnly) {
        for (DynamicWizardStep step : this.mySteps) {
            if (visibleOnly && !step.isStepVisible() || !stepName.equals(step.getStepName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void navigateToNamedStep(@NotNull String stepName, boolean requireVisible) {
        for (DynamicWizardStep step : this.mySteps) {
            if (requireVisible && !step.isStepVisible() || !stepName.equals(step.getStepName())) continue;
            this.myCurrentStep = step;
            this.myCurrentStepIndex = this.mySteps.indexOf(step);
            this.myCurrentStep.onEnterStep();
            this.myCurrentStep.invokeUpdate(null);
            this.invokeUpdate(null);
            return;
        }
    }

    @Nullable
    public MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    private class PathUpdate
    extends Update {
        public PathUpdate() {
            super((Object)DynamicWizardPath.this);
        }

        public void run() {
            DynamicWizardPath.this.update();
        }
    }
}

