/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.Stack;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizard
implements Disposable {
    private final List<ModelWizardStep> mySteps;
    private final Map<ModelWizardStep, ModelWizardStep> myStepOwners = Maps.newHashMap();
    private final BindingsManager myBindings = new BindingsManager();
    private final BoolProperty myCanGoBack = new BoolValueProperty();
    private final BoolProperty myCanGoForward = new BoolValueProperty();
    private final BoolProperty myOnLastStep = new BoolValueProperty();
    private final OptionalProperty<Action> myExtraAction = new OptionalValueProperty<Action>();
    private final Stack<ModelWizardStep> myPrevSteps = new Stack();
    private final TitleHeader myTitleHeader = new TitleHeader();
    private final JPanel myContentPanel = new JPanel(new CardLayout());
    private final List<WizardListener> myWizardListeners = Lists.newArrayListWithExpectedSize((int)1);
    private int myCurrIndex = -1;

    private ModelWizard(@NotNull Collection<ModelWizardStep> steps) {
        boolean bl;
        this.mySteps = Lists.newArrayListWithExpectedSize((int)steps.size());
        for (ModelWizardStep modelWizardStep : steps) {
            this.addStep(modelWizardStep);
        }
        if (this.mySteps.isEmpty()) {
            throw new IllegalStateException("Can't create a wizard with no steps");
        }
        this.myCanGoForward.addListener(sender -> {
            if (((Boolean)this.myCanGoForward.get()).booleanValue()) {
                this.myOnLastStep.set(this.isOnLastVisibleStep());
            }
        });
        HashSet seenModels = Sets.newHashSet();
        for (ModelWizardStep modelWizardStep : this.mySteps) {
            Disposer.register((Disposable)this, (Disposable)modelWizardStep);
            Object model = modelWizardStep.getModel();
            if (seenModels.contains(model)) continue;
            Disposer.register((Disposable)this, model);
            seenModels.add(model);
        }
        Facade facade = new Facade();
        for (ModelWizardStep step : this.mySteps) {
            step.onWizardStarting(facade);
        }
        boolean bl2 = false;
        for (ModelWizardStep step : this.mySteps) {
            if (!this.shouldShowStep(step)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.myCurrIndex = 1;
            Disposer.dispose((Disposable)this);
            throw new IllegalStateException("Trying to create a wizard but no steps are visible");
        }
        this.goForward();
    }

    @NotNull
    public ObservableBool canGoBack() {
        return this.myCanGoBack;
    }

    @NotNull
    public ObservableBool canGoForward() {
        return this.myCanGoForward;
    }

    @NotNull
    public ObservableBool onLastStep() {
        return this.myOnLastStep;
    }

    @NotNull
    public TitleHeader getTitleHeader() {
        return this.myTitleHeader;
    }

    @Nullable
    public JComponent getPreferredFocusComponent() {
        if (this.isFinished()) {
            return null;
        }
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        return step.getPreferredFocusComponent();
    }

    private void addStep(@NotNull ModelWizardStep<?> step) {
        this.myContentPanel.add((Component)step.getComponent(), Integer.toString(this.mySteps.size()));
        this.mySteps.add(step);
        for (ModelWizardStep subStep : step.createDependentSteps()) {
            this.myStepOwners.put(subStep, step);
            this.addStep(subStep);
        }
    }

    @NotNull
    ModelWizardStep getCurrentStep() {
        return this.mySteps.get(this.myCurrIndex);
    }

    @NotNull
    ObservableOptional<Action> getExtraAction() {
        return this.myExtraAction;
    }

    @NotNull
    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public void goForward() {
        this.ensureWizardIsRunning();
        ModelWizardStep prevStep = null;
        if (this.myCurrIndex >= 0) {
            ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
            if (!((Boolean)currStep.canGoForward().get()).booleanValue()) {
                throw new IllegalStateException("Can't call goForward on wizard when the step prevents it");
            }
            prevStep = currStep;
            try {
                prevStep.onProceeding();
            }
            catch (Exception e) {
                for (WizardListener listener : this.getListeners()) {
                    listener.onWizardAdvanceError(e);
                }
                throw e;
            }
        }
        ModelWizardStep nextStep = null;
        int nextIndex = this.myCurrIndex;
        while (++nextIndex < this.mySteps.size()) {
            ModelWizardStep step = this.mySteps.get(nextIndex);
            if (!this.shouldShowStep(step)) continue;
            nextStep = step;
            break;
        }
        try {
            if (nextStep != null) {
                nextStep.onEntering();
            }
        }
        catch (Exception e) {
            for (WizardListener listener : this.getListeners()) {
                listener.onWizardAdvanceError(e);
            }
            throw e;
        }
        if (prevStep != null) {
            this.myPrevSteps.add((Object)prevStep);
        }
        if (nextStep != null) {
            this.myCurrIndex = nextIndex;
            this.updateNavigationProperties();
            this.showCurrentStep();
        } else {
            this.handleFinished(WizardResult.FINISHED);
        }
    }

    public void goBack() {
        this.ensureWizardIsRunning();
        if (this.myPrevSteps.empty()) {
            throw new IllegalStateException("Calling back on wizard without any previous pages");
        }
        ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
        if (!currStep.canGoBack()) {
            throw new IllegalStateException("Can't call goBack on wizard when the step prevents it");
        }
        this.myCurrIndex = this.mySteps.indexOf(this.myPrevSteps.pop());
        this.updateNavigationProperties();
        this.showCurrentStep();
    }

    public void cancel() {
        this.ensureWizardIsRunning();
        this.handleFinished(WizardResult.CANCELLED);
    }

    public void addResultListener(@NotNull WizardListener listener) {
        this.myWizardListeners.add(listener);
    }

    public void removeResultListener(@NotNull WizardListener listener) {
        this.myWizardListeners.remove(listener);
    }

    public boolean isFinished() {
        return this.myCurrIndex >= this.mySteps.size();
    }

    private void ensureWizardIsRunning() {
        if (this.isFinished()) {
            throw new IllegalStateException("Invalid operation attempted after wizard already finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinished(@NotNull WizardResult result) {
        try {
            if (result == WizardResult.FINISHED) {
                Object model;
                HashSet seenModels = Sets.newHashSet();
                for (ModelWizardStep step : this.myPrevSteps) {
                    model = step.getModel();
                    if (seenModels.contains(model)) continue;
                    seenModels.add(model);
                    ((WizardModel)model).handleFinished();
                }
                for (ModelWizardStep step : this.mySteps) {
                    model = step.getModel();
                    if (seenModels.contains(model)) continue;
                    seenModels.add(model);
                    ((WizardModel)model).handleSkipped();
                }
            }
        }
        finally {
            this.myCurrIndex = this.mySteps.size();
            this.myPrevSteps.clear();
            this.myCanGoBack.set(false);
            this.myCanGoForward.set(false);
            this.myOnLastStep.set(false);
            for (WizardListener listener : this.getListeners()) {
                listener.onWizardFinished(result);
            }
        }
    }

    private void showCurrentStep() {
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myTitleHeader.title().set(step.getTitle());
        this.myTitleHeader.stepIcon().setNullableValue(step.getIcon());
        this.myExtraAction.setNullableValue(step.getExtraAction());
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, Integer.toString(this.myCurrIndex));
        JComponent focusedComponent = step.getPreferredFocusComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    private void updateNavigationProperties() {
        this.myOnLastStep.set(this.isOnLastVisibleStep());
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myBindings.bind(this.myCanGoForward, step.canGoForward());
        this.myCanGoBack.set(!this.myPrevSteps.empty() && step.canGoBack());
    }

    private boolean shouldShowStep(ModelWizardStep step) {
        ModelWizardStep currStep = step;
        do {
            if (currStep.shouldShow()) continue;
            return false;
        } while ((currStep = this.myStepOwners.get(currStep)) != null);
        return true;
    }

    private boolean isOnLastVisibleStep() {
        float size = this.mySteps.size();
        boolean currPageIsLast = true;
        int i = this.myCurrIndex + 1;
        while ((float)i < size) {
            ModelWizardStep step = this.mySteps.get(i);
            if (this.shouldShowStep(step)) {
                currPageIsLast = false;
                break;
            }
            ++i;
        }
        return currPageIsLast;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myWizardListeners.clear();
    }

    private Iterable<WizardListener> getListeners() {
        return Lists.newArrayList(this.myWizardListeners);
    }

    public final class Facade {
        public void updateNavigationProperties() {
            if (ModelWizard.this.myCurrIndex < 0) {
                return;
            }
            ModelWizard.this.updateNavigationProperties();
        }

        public boolean goForward() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to goForward before the wizard has even started");
            }
            if (((Boolean)ModelWizard.this.canGoForward().get()).booleanValue()) {
                ModelWizard.this.goForward();
                return true;
            }
            return false;
        }

        public void cancel() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to cancel before the wizard has even started");
            }
            ModelWizard.this.cancel();
        }
    }

    public static final class TitleHeader {
        private final StringProperty myTitle = new StringValueProperty();
        private final OptionalValueProperty<Icon> myStepIcon = new OptionalValueProperty();

        @NotNull
        public StringProperty title() {
            return this.myTitle;
        }

        @NotNull
        public OptionalValueProperty<Icon> stepIcon() {
            return this.myStepIcon;
        }
    }

    public static final class Builder {
        private final List<ModelWizardStep> mySteps;

        public Builder(ModelWizardStep ... steps) {
            this.mySteps = Lists.newArrayList((Object[])steps);
        }

        public Builder addStep(@NotNull ModelWizardStep step) {
            this.mySteps.add(step);
            return this;
        }

        public ModelWizard build() {
            return new ModelWizard(this.mySteps);
        }
    }

    public static interface WizardListener {
        default public void onWizardFinished(@NotNull WizardResult result) {
        }

        default public void onWizardAdvanceError(@NotNull Exception e) {
        }
    }

    public static enum WizardResult {
        FINISHED,
        CANCELLED;


        public boolean isFinished() {
            return this == FINISHED;
        }
    }
}

