/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizardDialog
extends DialogWrapper
implements ModelWizard.WizardListener {
    private CancellationPolicy myCancellationPolicy = CancellationPolicy.ALWAYS_CAN_CANCEL;
    @NotNull
    private ModelWizard myWizard;
    private final BindingsManager myBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();
    @Nullable
    private CustomLayout myCustomLayout;
    @Nullable
    private URL myHelpUrl;

    @NotNull
    protected Action[] createLeftSideActions() {
        return new Action[]{new StepActionWrapper()};
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout, @Nullable Project project, @Nullable URL helpUrl, @NotNull DialogWrapper.IdeModalityType modalityType, @NotNull CancellationPolicy cancellationPolicy) {
        super(project, true, modalityType);
        this.init(wizard, title, customLayout, helpUrl, cancellationPolicy);
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @NotNull Component parent, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy) {
        super(parent, true);
        this.init(wizard, title, customLayout, helpUrl, cancellationPolicy);
    }

    private void init(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy) {
        Disposer.register((Disposable)this.getDisposable(), (Disposable)wizard);
        this.myWizard = wizard;
        this.myWizard.addResultListener(this);
        this.myCustomLayout = customLayout;
        this.myHelpUrl = helpUrl;
        this.myCancellationPolicy = cancellationPolicy;
        this.setTitle(title);
        this.init();
        if (customLayout != null) {
            Disposer.register((Disposable)wizard, (Disposable)customLayout);
        }
    }

    protected void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myWizard.removeResultListener(this);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel wizardContent = this.myWizard.getContentPanel();
        return this.myCustomLayout == null ? wizardContent : this.myCustomLayout.decorate(this.myWizard.getTitleHeader(), wizardContent);
    }

    protected void doHelpAction() {
        assert (this.myHelpUrl != null);
        BrowserUtil.browse((URL)this.myHelpUrl);
    }

    public void doCancelAction() {
        this.myWizard.cancel();
    }

    public void doOKAction() {
    }

    @Override
    public void onWizardFinished(@NotNull ModelWizard.WizardResult result) {
        if (result.isFinished()) {
            super.doOKAction();
        } else {
            super.doCancelAction();
        }
    }

    @Override
    public void onWizardAdvanceError(@NotNull Exception e) {
        DialogEarthquakeShaker.shake((Window)this.getWindow());
    }

    @NotNull
    protected Action[] createActions() {
        NextAction nextAction = new NextAction();
        PreviousAction prevAction = new PreviousAction();
        FinishAction finishAction = new FinishAction();
        CancelAction cancelAction = new CancelAction(this.myCancellationPolicy);
        if (this.myHelpUrl == null) {
            if (SystemInfo.isMac) {
                return new Action[]{cancelAction, prevAction, nextAction, finishAction};
            }
            return new Action[]{prevAction, nextAction, cancelAction, finishAction};
        }
        if (SystemInfo.isMac) {
            return new Action[]{this.getHelpAction(), cancelAction, prevAction, nextAction, finishAction};
        }
        return new Action[]{prevAction, nextAction, cancelAction, finishAction, this.getHelpAction()};
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myWizard.getPreferredFocusComponent();
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action instanceof ModelWizardDialogAction) {
            ModelWizardDialogAction wizardAction = (ModelWizardDialogAction)((Object)action);
            this.myBindings.bind(new EnabledProperty(button), wizardAction.shouldBeEnabled());
            this.myBindings.bind(new VisibleProperty(button), wizardAction.shouldBeVisible());
            this.myListeners.receiveAndFire(wizardAction.shouldBeDefault(), isDefault -> {
                JRootPane rootPane = this.getRootPane();
                if (rootPane != null && isDefault.booleanValue()) {
                    rootPane.setDefaultButton(button);
                }
            });
        }
        return button;
    }

    private final class StepActionWrapper
    extends ModelWizardDialogAction {
        private final BoolValueProperty myEnabled;
        private final ObservableOptional<Action> myExtraAction;
        private PropertyChangeListener myActionListener;

        @Override
        @NotNull
        public ObservableBool shouldBeVisible() {
            return this.myExtraAction.isPresent();
        }

        public StepActionWrapper() {
            super("");
            this.myEnabled = new BoolValueProperty(false);
            this.myExtraAction = ModelWizardDialog.this.myWizard.getExtraAction();
            InvalidationListener extraActionChangedListener = new InvalidationListener(){
                Action myActiveAction = null;

                @Override
                public void onInvalidated(@NotNull ObservableValue<?> sender) {
                    if (this.myActiveAction != null && StepActionWrapper.this.myActionListener != null) {
                        this.myActiveAction.removePropertyChangeListener(StepActionWrapper.this.myActionListener);
                    }
                    this.myActiveAction = (Action)StepActionWrapper.this.myExtraAction.getValueOrNull();
                    if (this.myActiveAction != null) {
                        StepActionWrapper.this.putValue("Name", this.myActiveAction.getValue("Name"));
                        StepActionWrapper.this.myActionListener = evt -> {
                            if ("enabled".equals(evt.getPropertyName())) {
                                StepActionWrapper.this.myEnabled.set((Boolean)evt.getNewValue());
                            }
                        };
                        this.myActiveAction.addPropertyChangeListener(StepActionWrapper.this.myActionListener);
                        StepActionWrapper.this.myEnabled.set(this.myActiveAction.isEnabled());
                    } else {
                        StepActionWrapper.this.myActionListener = null;
                    }
                }
            };
            this.myExtraAction.addListener(extraActionChangedListener);
            extraActionChangedListener.onInvalidated(this.myExtraAction);
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return this.myEnabled;
        }

        protected void doAction(ActionEvent e) {
            assert (((Optional)this.myExtraAction.get()).isPresent());
            this.myExtraAction.getValue().actionPerformed(e);
        }
    }

    private final class CancelAction
    extends ModelWizardDialogAction {
        private final CancellationPolicy myCancellationPolicy;

        private CancelAction(CancellationPolicy cancellationPolicy) {
            super(IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
            this.myCancellationPolicy = cancellationPolicy;
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.doCancelAction();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            switch (this.myCancellationPolicy) {
                case CAN_CANCEL_UNTIL_CAN_FINISH: {
                    return BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep().and(ModelWizardDialog.this.myWizard.canGoForward()));
                }
            }
            return BooleanExpressions.alwaysTrue();
        }
    }

    private final class FinishAction
    extends ModelWizardDialogAction {
        FinishAction() {
            super(IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myWizard.onLastStep().and(ModelWizardDialog.this.myWizard.canGoForward());
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            return ModelWizardDialog.this.myWizard.onLastStep();
        }
    }

    private final class PreviousAction
    extends ModelWizardDialogAction {
        PreviousAction() {
            super(IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goBack();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myWizard.canGoBack();
        }
    }

    private final class NextAction
    extends ModelWizardDialogAction {
        NextAction() {
            super(IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            return ModelWizardDialog.this.myWizard.canGoForward().and(BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep()));
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            return BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep());
        }
    }

    private abstract class ModelWizardDialogAction
    extends DialogWrapper.DialogWrapperAction {
        public ModelWizardDialogAction(String name) {
            super((DialogWrapper)ModelWizardDialog.this, name);
        }

        @NotNull
        public abstract ObservableBool shouldBeEnabled();

        @NotNull
        public ObservableBool shouldBeVisible() {
            return BooleanExpressions.alwaysTrue();
        }

        @NotNull
        public ObservableBool shouldBeDefault() {
            return BooleanExpressions.alwaysFalse();
        }
    }

    public static interface CustomLayout
    extends Disposable {
        @NotNull
        public JPanel decorate(@NotNull ModelWizard.TitleHeader var1, @NotNull JPanel var2);

        public Dimension getDefaultPreferredSize();

        public Dimension getDefaultMinSize();
    }

    public static enum CancellationPolicy {
        ALWAYS_CAN_CANCEL,
        CAN_CANCEL_UNTIL_CAN_FINISH;

    }
}

