/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelWizardStep<M extends WizardModel>
implements Disposable {
    @NotNull
    private final M myModel;
    @NotNull
    private final String myTitle;
    @Nullable
    private Icon myIcon;

    protected ModelWizardStep(@NotNull M model, @NotNull String title) {
        this.myModel = model;
        this.myTitle = title;
    }

    protected ModelWizardStep(@NotNull M model, @NotNull String title, @NotNull Icon icon) {
        this.myModel = model;
        this.myTitle = title;
        this.myIcon = icon;
    }

    @NotNull
    public final String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    protected final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    @NotNull
    protected abstract JComponent getComponent();

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return null;
    }

    @NotNull
    protected final M getModel() {
        return this.myModel;
    }

    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        return ImmutableList.of();
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
    }

    protected boolean shouldShow() {
        return true;
    }

    @NotNull
    protected ObservableBool canGoForward() {
        return BooleanExpressions.alwaysTrue();
    }

    protected boolean canGoBack() {
        return true;
    }

    protected void onEntering() {
    }

    protected void onProceeding() {
    }

    public void dispose() {
    }

    @Nullable
    protected Action getExtraAction() {
        return null;
    }

    public static abstract class WithoutModel
    extends ModelWizardStep<BlankModel> {
        protected WithoutModel(@NotNull String title) {
            super(new BlankModel(), title);
        }
    }

    private static final class BlankModel
    extends WizardModel {
        private BlankModel() {
        }

        @Override
        protected void handleFinished() {
        }
    }
}

