/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.Function;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TemplateWizardState
implements Function<String, Object> {
    public static final String ACTIVITY_NAME_SUFFIX = "Activity";
    public static final String LAYOUT_NAME_PREFIX = "activity_";
    private static final String MAIN_FLAVOR_SOURCE_PATH = "src" + File.separator + "main";
    private static final String TEST_SOURCE_PATH = "src" + File.separator + "androidTest";
    private static final String JAVA_SOURCE_PATH = "java";
    private static final String RESOURCE_SOURCE_PATH = "res";
    private static final String AIDL_SOURCE_PATH = "aidl";
    private static final Logger logger = Logger.getInstance(TemplateWizardState.class);
    @Nullable
    private Template myTemplate;
    private final Map<String, Object> myParameters = new HashMap<String, Object>();
    public final Set<String> myHidden = new HashSet<String>();
    private final Set<String> myFinal = new HashSet<String>();
    public final Set<String> myModified = new HashSet<String>();

    public TemplateWizardState() {
        this.put("isNewProject", false);
        this.put("isGradle", true);
        this.put("isLibraryProject", false);
        this.put("hasApplicationTheme", true);
        this.put("srcDir", "src/main/java");
        this.put("resDir", "src/main/res");
        this.put("aidlDir", "src/main/aidl");
        this.put("manifestDir", "src/main");
        this.put("testDir", "src/androidTest");
    }

    public TemplateWizardState(@NotNull Template template) {
        this();
        this.myTemplate = template;
    }

    public void populateDirectoryParameters() {
        File projectRoot = new File(this.getString("projectLocation"));
        File moduleRoot = new File(projectRoot, this.getString("projectName"));
        File mainFlavorSourceRoot = new File(moduleRoot, MAIN_FLAVOR_SOURCE_PATH);
        File testSourceRoot = new File(moduleRoot, TEST_SOURCE_PATH);
        if (!this.myParameters.containsKey("resOut") || this.myParameters.get("resOut") == null) {
            File resourceSourceRoot = new File(mainFlavorSourceRoot, RESOURCE_SOURCE_PATH);
            this.put("resOut", FileUtil.toSystemIndependentName((String)resourceSourceRoot.getPath()));
        }
        String javaPackageDir = this.getString("packageName").replace('.', File.separatorChar);
        if (!this.myParameters.containsKey("srcOut") || this.myParameters.get("srcOut") == null) {
            File javaSourcePackageRoot;
            File javaSourceRoot = new File(mainFlavorSourceRoot, JAVA_SOURCE_PATH);
            if (this.myParameters.containsKey("packageRoot")) {
                javaSourcePackageRoot = new File(this.getString("packageRoot"));
                String relativePath = FileUtil.getRelativePath((File)javaSourceRoot, (File)javaSourcePackageRoot);
                String javaPackage = relativePath != null ? FileUtil.toSystemIndependentName((String)relativePath).replace('/', '.') : null;
                this.put("packageName", javaPackage);
            } else {
                javaSourcePackageRoot = new File(javaSourceRoot, javaPackageDir);
            }
            this.put("srcOut", FileUtil.toSystemIndependentName((String)javaSourcePackageRoot.getPath()));
        }
        if (!this.myParameters.containsKey("aidlOut") || this.get("aidlOut") == null) {
            File aidlRoot = new File(mainFlavorSourceRoot, AIDL_SOURCE_PATH);
            File aidlOut = new File(aidlRoot, javaPackageDir);
            this.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlOut.getPath()));
        }
        if (!this.myParameters.containsKey("manifestOut") || this.myParameters.get("manifestOut") == null) {
            this.put("manifestOut", FileUtil.toSystemIndependentName((String)mainFlavorSourceRoot.getPath()));
        }
        if (!this.myParameters.containsKey("testOut") || this.myParameters.get("testOut") == null) {
            String relativeTestOut = FileUtil.join((String[])new String[]{JAVA_SOURCE_PATH, javaPackageDir});
            File testOut = new File(testSourceRoot, relativeTestOut);
            this.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getPath()));
        }
        this.put("topOut", FileUtil.toSystemIndependentName((String)projectRoot.getPath()));
        this.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getPath()));
    }

    public boolean hasTemplate() {
        return this.myTemplate != null && this.myTemplate.getMetadata() != null;
    }

    @Nullable
    public Template getTemplate() {
        return this.myTemplate;
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata() {
        if (this.myTemplate == null) {
            return null;
        }
        return this.myTemplate.getMetadata();
    }

    @NotNull
    public Map<String, Object> getParameters() {
        return this.myParameters;
    }

    @Nullable
    public Object get(@NotNull String key) {
        return this.myParameters.get(key);
    }

    public boolean getBoolean(@NotNull String key) {
        return this.get(key, Boolean.class);
    }

    public int getInt(@NotNull String key) {
        return this.get(key, Integer.class);
    }

    @NotNull
    public String getString(@NotNull String key) {
        return this.get(key, String.class);
    }

    @NotNull
    private <T> T get(@NotNull String key, @NotNull Class<T> valueType) {
        Object val = this.get(key);
        assert (valueType.isInstance(val));
        return valueType.cast(val);
    }

    public boolean hasAttr(String key) {
        return this.myParameters.containsKey(key);
    }

    public void put(@NotNull String key, @Nullable Object value) {
        this.myParameters.put(key, value);
    }

    public void setTemplateLocation(@NotNull File file) {
        if (this.myTemplate == null || !this.myTemplate.getRootPath().getAbsolutePath().equals(file.getAbsolutePath())) {
            if (this.myTemplate != null && this.myTemplate.getMetadata() != null) {
                for (Parameter param : this.myTemplate.getMetadata().getParameters()) {
                    if (this.myFinal.contains(param.id)) continue;
                    this.myParameters.remove(param.id);
                }
            }
            this.myTemplate = Template.createFromPath(file);
            this.setParameterDefaults();
        }
    }

    public void setParameterDefaults() {
        TemplateMetadata metadata = this.myTemplate.getMetadata();
        if (metadata == null) {
            logger.warn("Null metadata");
            return;
        }
        for (Parameter param : metadata.getParameters()) {
            if (this.myFinal.contains(param.id) || this.myParameters.containsKey(param.id) || param.initial == null) continue;
            assert (param.id != null);
            switch (param.type) {
                case BOOLEAN: {
                    this.put(param.id, Boolean.valueOf(param.initial));
                    break;
                }
                case ENUM: 
                case STRING: {
                    this.put(param.id, param.initial);
                    break;
                }
            }
        }
    }

    public Object apply(String input) {
        return this.get(input);
    }
}

