/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.swing.layoutlib.AlreadyDisposedException;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicsLayoutRenderer {
    private static final Logger LOG = Logger.getInstance(GraphicsLayoutRenderer.class);
    private static final int MIN_LAYOUTLIB_API_VERSION = 15;
    private final FakeImageFactory myImageFactory;
    private final DynamicHardwareConfig myHardwareConfig;
    private final Object myCredential;
    private final RenderSecurityManager mySecurityManager;
    private boolean myInvalidate;
    private final List<ResourceValue> myResourceLookupChain;
    private final ReentrantReadWriteLock myRenderSessionLock = new ReentrantReadWriteLock();
    private RenderSession myRenderSession;
    private double myScale = 1.0;

    private GraphicsLayoutRenderer(@NotNull LayoutLibrary layoutLib, @NotNull SessionParams sessionParams, @Nullable RenderSecurityManager securityManager, @NotNull DynamicHardwareConfig hardwareConfig, @NotNull List<ResourceValue> resourceLookupChain, @NotNull Object credential, @NotNull Project project) {
        this.mySecurityManager = securityManager;
        this.myHardwareConfig = hardwareConfig;
        this.myImageFactory = new FakeImageFactory();
        this.myResourceLookupChain = resourceLookupChain;
        this.myCredential = credential;
        sessionParams.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)Boolean.TRUE);
        sessionParams.setImageFactory((IImageFactory)this.myImageFactory);
        this.myRenderSession = GraphicsLayoutRenderer.initRenderSession(layoutLib, sessionParams, this.mySecurityManager, this.myCredential, project);
    }

    @VisibleForTesting
    @NotNull
    static GraphicsLayoutRenderer create(@NotNull AndroidFacet facet, @NotNull AndroidPlatform platform, @NotNull Project project, @NotNull Configuration configuration, @NotNull ILayoutPullParser parser, @Nullable Color backgroundColor, @NotNull SessionParams.RenderingMode renderingMode, boolean useSecurityManager) throws InitializationException {
        LayoutLibrary layoutLib;
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        try {
            IAndroidTarget latestTarget = configuration.getConfigurationManager().getHighestApiTarget();
            if (latestTarget == null) {
                throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
            }
            layoutLib = platform.getSdkData().getTargetData(latestTarget).getLayoutLibrary(project);
            if (layoutLib == null) {
                throw new InitializationException("getLayoutLibrary() returned null");
            }
        }
        catch (RenderingException e) {
            throw new InitializationException(e);
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        if (layoutLib.getApiLevel() < 15) {
            throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
        }
        AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance(facet);
        final Module module = facet.getModule();
        Object credential = new Object();
        RenderLogger logger = new RenderLogger("theme_editor", module, credential);
        final ActionBarCallback actionBarCallback = new ActionBarCallback();
        final LayoutlibCallbackImpl layoutlibCallback = new LayoutlibCallbackImpl(null, layoutLib, appResources, module, facet, logger, credential, null, null){

            @Override
            public ActionBarCallback getActionBarCallback() {
                return actionBarCallback;
            }
        };
        boolean loadRResult = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (module.isDisposed()) {
                    return false;
                }
                layoutlibCallback.loadAndParseRClass();
                return true;
            }
        });
        if (!loadRResult) {
            throw new AlreadyDisposedException("Module was already disposed");
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            throw new InitializationException("Unable to get IAndroidTarget");
        }
        Device device = configuration.getDevice();
        assert (device != null);
        HardwareConfigHelper hardwareConfigHelper = new HardwareConfigHelper(device);
        DynamicHardwareConfig hardwareConfig = new DynamicHardwareConfig(hardwareConfigHelper.getConfig());
        ArrayList<ResourceValue> resourceLookupChain = new ArrayList<ResourceValue>();
        ResourceResolver resourceResolver = ResourceResolver.copy((ResourceResolver)configuration.getResourceResolver());
        assert (resourceResolver != null);
        ResourceResolver recordingResourceResolver = resourceResolver.createRecorder(resourceLookupChain);
        SessionParams params = new SessionParams(parser, renderingMode, (Object)module, (HardwareConfig)hardwareConfig, (RenderResources)recordingResourceResolver, (LayoutlibCallback)layoutlibCallback, moduleInfo.getMinSdkVersion().getApiLevel(), moduleInfo.getTargetSdkVersion().getApiLevel(), (LayoutLog)logger, target instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)new AssetRepositoryImpl(facet));
        params.setAppLabel("");
        if (backgroundColor != null) {
            params.setOverrideBgColor(backgroundColor.getRGB());
        }
        RenderSecurityManager mySecurityManager = useSecurityManager ? RenderSecurityManagerFactory.create(module, platform) : null;
        return new GraphicsLayoutRenderer(layoutLib, params, mySecurityManager, hardwareConfig, resourceLookupChain, credential, project);
    }

    @NotNull
    public static GraphicsLayoutRenderer create(@NotNull Configuration configuration, @NotNull ILayoutPullParser parser, @Nullable Color backgroundColor, boolean hasHorizontalScroll, boolean hasVerticalScroll) throws InitializationException {
        Module module = configuration.getModule();
        if (module.isDisposed()) {
            throw new AlreadyDisposedException("Module was already disposed");
        }
        AndroidFacet facet = AndroidFacet.getInstance(configuration.getModule());
        if (facet == null) {
            throw new InitializationException("Unable to get AndroidFacet");
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            throw new UnsupportedLayoutlibException("No Android SDK found.");
        }
        SessionParams.RenderingMode renderingMode = hasVerticalScroll && hasHorizontalScroll ? SessionParams.RenderingMode.FULL_EXPAND : (hasVerticalScroll ? SessionParams.RenderingMode.V_SCROLL : (hasHorizontalScroll ? SessionParams.RenderingMode.H_SCROLL : SessionParams.RenderingMode.NORMAL));
        return GraphicsLayoutRenderer.create(facet, platform, module.getProject(), configuration, parser, backgroundColor, renderingMode, true);
    }

    @NotNull
    private Dimension modelToView(int width, int height) {
        return new Dimension((int)((double)width * this.myScale), (int)((double)height * this.myScale));
    }

    @NotNull
    private Dimension viewToModel(int width, int height) {
        return new Dimension((int)((double)width / this.myScale), (int)((double)height / this.myScale));
    }

    @NotNull
    private Point viewToModel(@NotNull Point p) {
        return new Point((int)((double)p.x / this.myScale), (int)((double)p.y / this.myScale));
    }

    public void setScale(double scale) {
        this.myScale = scale;
        this.setSize(new Dimension(this.myHardwareConfig.getScreenWidth(), this.myHardwareConfig.getScreenHeight()));
    }

    public void setSize(int width, int height) {
        Dimension dimen = this.viewToModel(width, height);
        this.myHardwareConfig.setScreenSize(Math.max(dimen.width, 1), Math.max(dimen.height, 1));
        this.myInvalidate = true;
    }

    public void setSize(Dimension dimen) {
        this.setSize(dimen.width, dimen.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(@NotNull Graphics2D graphics) {
        this.myRenderSessionLock.readLock().lock();
        try {
            if (this.myRenderSession == null) {
                LOG.warn("Render error: Render session is null ");
                boolean bl = false;
                return bl;
            }
            if (!SystemInfo.isMac) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.myImageFactory.setGraphics(graphics);
            AffineTransform oldTransform = graphics.getTransform();
            if (this.myScale != 1.0) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                AffineTransform scaleTransform = new AffineTransform(oldTransform);
                scaleTransform.scale(this.myScale, this.myScale);
                graphics.setTransform(scaleTransform);
            }
            Result result = null;
            try {
                RenderSession renderSession = this.myRenderSession;
                result = RenderService.runRenderAction(() -> {
                    if (this.mySecurityManager != null) {
                        this.mySecurityManager.setActive(true, this.myCredential);
                    }
                    try {
                        Result result = renderSession.render(250L, this.myInvalidate);
                        return result;
                    }
                    finally {
                        if (this.mySecurityManager != null) {
                            this.mySecurityManager.setActive(false, this.myCredential);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Exception running render action", (Throwable)e);
            }
            if (this.myScale != 1.0) {
                graphics.setTransform(oldTransform);
            }
            if (result != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
                boolean bl = false;
                return bl;
            }
            this.myInvalidate = false;
            boolean bl = true;
            return bl;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    @Nullable
    private static RenderSession initRenderSession(@NotNull LayoutLibrary layoutLibrary, @NotNull SessionParams sessionParams, @Nullable RenderSecurityManager securityManager, @NotNull Object credential, @NotNull Project project) {
        try {
            Result result;
            RenderSession session = RenderService.runRenderAction(() -> {
                if (securityManager != null) {
                    securityManager.setActive(true, credential);
                }
                try {
                    assert (!ApplicationManager.getApplication().isDispatchThread());
                    RenderSession renderSession = (RenderSession)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> layoutLibrary.createSession(sessionParams));
                    return renderSession;
                }
                finally {
                    if (securityManager != null) {
                        securityManager.setActive(false, credential);
                    }
                }
            });
            if (session == null) {
                LOG.warn("initRenderSession failed (returned null)");
                return null;
            }
            if (layoutLibrary.supports(17)) {
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            if ((result = session.getResult()) != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
            }
            return session;
        }
        catch (Exception e) {
            LOG.warn("initRenderSession failed", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public Set<String> getUsedAttrs() {
        HashSet<String> usedAttrs = new HashSet<String>();
        for (ResourceValue value : this.myResourceLookupChain) {
            if (!(value instanceof ItemResourceValue) || value.getName() == null) continue;
            ItemResourceValue itemValue = (ItemResourceValue)value;
            usedAttrs.add((itemValue.isFrameworkAttr() ? "android:" : "") + itemValue.getName());
        }
        return Collections.unmodifiableSet(usedAttrs);
    }

    @Nullable
    private static ViewInfo viewAtPoint(@NotNull Point parentPosition, @NotNull ViewInfo view, @NotNull Point p) {
        int y;
        ViewInfo bounds = RenderService.getSafeBounds(view);
        int x = parentPosition.x + bounds.getLeft();
        Rectangle rect = new Rectangle(x, y = parentPosition.y + bounds.getTop(), bounds.getRight() - bounds.getLeft(), bounds.getBottom() - bounds.getTop());
        if (rect.contains(p)) {
            for (ViewInfo childView : view.getChildren()) {
                ViewInfo hitView;
                if (childView.getCookie() == null || (hitView = GraphicsLayoutRenderer.viewAtPoint(rect.getLocation(), childView, p)) == null) continue;
                return hitView;
            }
            return view;
        }
        return null;
    }

    @NotNull
    public List<ViewInfo> getRootViews() {
        return this.myRenderSession == null ? Collections.emptyList() : this.myRenderSession.getRootViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ViewInfo findViewAtPoint(@NotNull Point p) {
        this.myRenderSessionLock.readLock().lock();
        try {
            if (this.myRenderSession == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            p = this.viewToModel(p);
            List rootViews = this.myRenderSession.getRootViews();
            if (rootViews == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            Point base = new Point();
            for (ViewInfo view : rootViews) {
                ViewInfo hitView = GraphicsLayoutRenderer.viewAtPoint(base, view, p);
                if (hitView == null) continue;
                ViewInfo viewInfo = hitView;
                return viewInfo;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    public Dimension getPreferredSize() {
        return this.modelToView(this.myImageFactory.getRequestedWidth(), this.myImageFactory.getRequestedHeight());
    }

    public void dispose() {
        this.myRenderSessionLock.writeLock().lock();
        try {
            if (this.myRenderSession != null) {
                this.myImageFactory.setGraphics(null);
                RenderService.runRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                this.myRenderSession = null;
            }
        }
        catch (Exception e) {
            LOG.error("Error while disposing the session", (Throwable)e);
        }
        finally {
            this.myRenderSessionLock.writeLock().unlock();
        }
    }

    static class DynamicHardwareConfig
    extends HardwareConfig {
        private int myWidth;
        private int myHeight;

        public DynamicHardwareConfig(HardwareConfig delegate) {
            super(delegate.getScreenWidth(), delegate.getScreenHeight(), delegate.getDensity(), delegate.getXdpi(), delegate.getYdpi(), delegate.getScreenSize(), delegate.getOrientation(), delegate.getScreenRoundness(), delegate.hasSoftwareButtons());
            this.myWidth = delegate.getScreenWidth();
            this.myHeight = delegate.getScreenHeight();
        }

        public void setScreenSize(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }
    }
}

