/*
 * Decompiled with CFR 0.152.
 */
package com.google.idea.blaze.android.run.test;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectJavaDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReattachingDebugConnectorTaskBase
extends ConnectJavaDebuggerTask {
    private static final int CHANGE_MASK = 3;

    public ReattachingDebugConnectorTaskBase(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        super(applicationIds, debugger, project, monitorRemoteProcess, false);
    }

    @Override
    @Nullable
    public ProcessHandler perform(@NotNull LaunchInfo launchInfo, @NotNull IDevice device, @NotNull ProcessHandlerLaunchStatus status, @NotNull ProcessHandlerConsolePrinter printer) {
        AndroidDebugBridge.IClientChangeListener reattachingListener = (client, changeMask) -> {
            ClientData data = client.getClientData();
            String clientDescription = data.getClientDescription();
            if (this.myApplicationIds.contains(clientDescription) && (changeMask & 3) != 0 && data.getDebuggerConnectionStatus().equals((Object)ClientData.DebuggerStatus.WAITING)) {
                ApplicationManager.getApplication().invokeLater(() -> this.launchDebugger(launchInfo, client, status, printer));
            }
        };
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)reattachingListener);
        this.registerLaunchTaskCompleteCallback(() -> AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)reattachingListener));
        return null;
    }

    protected abstract void registerLaunchTaskCompleteCallback(@NotNull Runnable var1);
}

