/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidIdIndex
extends FileBasedIndexExtension<String, Set<String>> {
    public static final ID<String, Set<String>> INDEX_ID = ID.create((String)"android.id.index");
    public static final String MARKER = "$";
    private static final DataIndexer<String, Set<String>, FileContent> INDEXER = new DataIndexer<String, Set<String>, FileContent>(){

        @NotNull
        public Map<String, Set<String>> map(@NotNull FileContent inputData) {
            CharSequence content = inputData.getContentAsText();
            if (CharArrayUtil.indexOf((CharSequence)content, (CharSequence)"http://schemas.android.com/apk/res/android", (int)0) == -1) {
                return Collections.emptyMap();
            }
            final HashMap map = new HashMap();
            NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    String id;
                    super.addAttribute(key, nsPrefix, nsURI, value, type);
                    boolean declaration = AndroidResourceUtil.isIdDeclaration(value);
                    if ((declaration || AndroidResourceUtil.isIdReference(value)) && (id = AndroidResourceUtil.getResourceNameByReferenceText(value)) != null) {
                        if (declaration) {
                            id = "+" + id;
                        }
                        map.put((Object)id, Collections.emptySet());
                    }
                }
            });
            if (!map.isEmpty()) {
                map.put((Object)AndroidIdIndex.MARKER, (Object)new HashSet((Collection)map.keySet()));
            }
            return map;
        }
    };
    private static final DataExternalizer<Set<String>> DATA_EXTERNALIZER = new DataExternalizer<Set<String>>(){

        public void save(@NotNull DataOutput out, Set<String> value) throws IOException {
            out.writeInt(value.size());
            for (String s : value) {
                out.writeUTF(s);
            }
        }

        public Set<String> read(@NotNull DataInput in) throws IOException {
            int size = in.readInt();
            if (size < 0 || size > 65535) {
                throw new IOException("Corrupt Index: Size " + size);
            }
            HashSet result = new HashSet(size);
            for (int i = 0; i < size; ++i) {
                String s = in.readUTF();
                result.add(s);
            }
            return result;
        }
    };

    @NotNull
    public ID<String, Set<String>> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        return INDEXER;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        return DATA_EXTERNALIZER;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return file.isInLocalFileSystem();
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }
}

