/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;

public class ClassMaps
extends AndroidFacetScopedService {
    private static final Key<ClassMaps> KEY = Key.create((String)ClassMaps.class.getName());
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps = Maps.newConcurrentMap();

    @NotNull
    public static ClassMaps getInstance(@NotNull AndroidFacet facet) {
        ClassMaps classMaps = (ClassMaps)facet.getUserData(KEY);
        if (classMaps == null) {
            classMaps = new ClassMaps(facet);
            facet.putUserData(KEY, classMaps);
        }
        return classMaps;
    }

    private ClassMaps(@NotNull AndroidFacet facet) {
        super(facet);
    }

    @NotNull
    public Map<String, PsiClass> getClassMap(@NotNull String className) {
        CachedValue value = this.myClassMaps.get(className);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                Map<String, PsiClass> map = this.computeClassMap(className);
                return CachedValueProvider.Result.create(map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
        }
        return (Map)value.getValue();
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap<String, PsiClass> result = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!ClassMaps.isUpToDate(pointer, key)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result.put(key, aClass);
            }
        }
        this.fillMap(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), result, false);
        return result;
    }

    private static boolean isUpToDate(@NotNull SmartPsiElementPointer<PsiClass> pointer, String tagName) {
        PsiClass aClass = (PsiClass)pointer.getElement();
        if (aClass == null) {
            return false;
        }
        Object[] tagNames = LayoutViewClassUtils.getTagNamesByClass(aClass, -1);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = this.myInitialClassMaps.get(className);
        if (viewClassMap != null && !forceRebuild) {
            return viewClassMap;
        }
        HashMap<String, PsiClass> map = new HashMap<String, PsiClass>();
        if (this.fillMap(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), map, true)) {
            viewClassMap = new HashMap<String, SmartPsiElementPointer<PsiClass>>(map.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getProject());
            for (Map.Entry entry : map.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        return viewClassMap != null ? viewClassMap : Collections.emptyMap();
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, @NotNull Map<String, PsiClass> map, boolean libClassesOnly) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            try {
                aClass = facade.findClass(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.getFacet());
        if (baseClass != null) {
            String[] baseClassTagNames;
            for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, androidModuleInfo.getModuleMinApi())) {
                map.put(tagName, baseClass);
            }
            try {
                ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                    String[] tagNames;
                    if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                        return true;
                    }
                    for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, androidModuleInfo.getModuleMinApi())) {
                        map.put(tagName, (PsiClass)c);
                    }
                    return true;
                });
            }
            catch (IndexNotReadyException e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
                return false;
            }
        }
        return !map.isEmpty();
    }

    @NotNull
    private Project getProject() {
        return this.getModule().getProject();
    }

    public void clear() {
        this.myInitialClassMaps.clear();
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

