/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidRunSdkToolAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AndroidRunSdkToolAction.class);

    public AndroidRunSdkToolAction(String text) {
        super(text);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        this.doAction(project);
    }

    public void doAction(@NotNull Project project) {
        File androidHome;
        if (IdeInfo.getInstance().isAndroidStudio() && (androidHome = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
            this.doRunTool(project, androidHome.getPath());
            return;
        }
        try {
            LocalProperties localProperties = new LocalProperties(project);
            File androidSdkPath = localProperties.getAndroidSdkPath();
            if (androidSdkPath != null) {
                this.doRunTool(project, androidSdkPath.getPath());
                return;
            }
        }
        catch (IOException ignored) {
            LOG.info(String.format("Unable to read local.properties file from project '%1$s'", project.getName()), (Throwable)ignored);
        }
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        assert (!facets.isEmpty());
        HashSet sdkSet = new HashSet();
        for (AndroidFacet facet : facets) {
            AndroidSdkData sdkData = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidSdk();
            if (sdkData == null) continue;
            sdkSet.add(sdkData.getLocation().getPath());
        }
        if (sdkSet.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("specify.platform.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String sdkPath = (String)sdkSet.iterator().next();
        if (sdkSet.size() > 1) {
            String[] sdks = ArrayUtil.toStringArray((Collection)sdkSet);
            int index = Messages.showChooseDialog((Project)project, (String)AndroidBundle.message("android.choose.sdk.label", new Object[0]), (String)AndroidBundle.message("android.choose.sdk.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])sdks, (String)sdkPath);
            if (index < 0) {
                return;
            }
            sdkPath = sdks[index];
        }
        this.doRunTool(project, sdkPath);
    }

    protected abstract void doRunTool(@NotNull Project var1, @NotNull String var2);
}

