/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.google.common.collect.Maps;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceFileActionGroup;
import org.jetbrains.android.actions.CreateResourceFileDialogBase;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileAction
extends CreateResourceActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.CreateResourceFileAction");
    private final Map<ResourceFolderType, CreateTypedResourceFileAction> mySubactions = Maps.newEnumMap(ResourceFolderType.class);
    private String myRootElement;
    private boolean myNavigate;

    @NotNull
    public static CreateResourceFileAction getInstance() {
        AnAction action = ActionManager.getInstance().getAction("Android.CreateResourcesActionGroup");
        assert (action instanceof CreateResourceFileActionGroup);
        return ((CreateResourceFileActionGroup)action).getCreateResourceFileAction();
    }

    public CreateResourceFileAction() {
        super(AndroidBundle.message("new.resource.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), StdFileTypes.XML.getIcon());
    }

    public void add(CreateTypedResourceFileAction action) {
        this.mySubactions.put(action.getResourceFolderType(), action);
    }

    public Collection<CreateTypedResourceFileAction> getSubactions() {
        return this.mySubactions.values();
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }

    static boolean isOutsideResourceTypeFolder(@NotNull DataContext context) {
        Module module;
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParent();
            }
            if (file != null && ResourceFolderType.getFolderType((String)file.getName()) != null) {
                return false;
            }
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(context)) != null) {
            return AndroidFacet.getInstance(module) != null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        return element != null && AndroidFacet.getInstance(element) != null;
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate) {
        PsiElement[] elements = CreateResourceFileAction.doCreateFileResource(facet, resType, resName, rootElement, config, chooseResName, dialogTitle, resDirectory, dataContext, navigate);
        if (elements.length == 0) {
            return null;
        }
        assert (elements.length == 1 && elements[0] instanceof XmlFile);
        return (XmlFile)elements[0];
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType folderType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext) {
        return CreateResourceFileAction.createFileResource(facet, folderType, resName, rootElement, config, chooseResName, dialogTitle, resDirectory, dataContext, true);
    }

    @NotNull
    private static PsiElement[] doCreateFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate) {
        CreateResourceFileAction action = CreateResourceFileAction.getInstance();
        Project project = facet.getModule().getProject();
        action.myNavigate = navigate;
        CreateResourceFileDialogBase.ValidatorFactory validatorFactory = action.createValidatorFactory(project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String subdirName = resType.getName();
            VirtualFile resDir = facet.getPrimaryResourceDir();
            if (resDir == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiDirectory resourceDir = PsiManager.getInstance((Project)project).findDirectory(resDir);
            if (resourceDir == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            ElementCreatingValidator inputValidator = validatorFactory.create(resourceDir, subdirName, null);
            return inputValidator.checkInput(resName) && inputValidator.canClose(resName) ? ((CreateResourceActionBase.MyInputValidator)inputValidator).getCreatedElements() : PsiElement.EMPTY_ARRAY;
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog = newResourceHandler.createNewResourceFileDialog(facet, action.mySubactions.values(), resType, resName, rootElement, config, chooseResName, true, resDirectory, dataContext, validatorFactory);
        if (dialogTitle != null) {
            dialog.setTitle(dialogTitle);
        }
        if (!dialog.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog.getCreatedElements();
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        LOG.assertTrue(facet != null);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        ResourceFolderType folderType = CreateResourceFileAction.getUniqueFolderType(files);
        FolderConfiguration config = null;
        if (files != null && files.length > 0) {
            config = files.length == 1 ? FolderConfiguration.getConfigForFolder((String)files[0].getName()) : null;
        }
        this.myNavigate = true;
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog = newResourceHandler.createNewResourceFileDialog(facet, this.mySubactions.values(), folderType, null, null, config, true, false, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, this.createValidatorFactory(project));
        if (!dialog.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog.getCreatedElements();
    }

    @Nullable
    static ResourceFolderType getUniqueFolderType(@Nullable VirtualFile[] files) {
        ResourceFolderType folderType = null;
        if (files != null && files.length > 0) {
            for (VirtualFile file : files) {
                ResourceFolderType type;
                if (!file.isDirectory()) {
                    file = file.getParent();
                }
                if (file == null || (type = ResourceFolderType.getFolderType((String)file.getName())) == null) continue;
                if (type != folderType && folderType != null) {
                    folderType = null;
                    break;
                }
                folderType = type;
            }
        }
        return folderType;
    }

    @NotNull
    private CreateResourceFileDialogBase.ValidatorFactory createValidatorFactory(final @NotNull Project project) {
        return new CreateResourceFileDialogBase.ValidatorFactory(){

            @Override
            @NotNull
            public ElementCreatingValidator create(@NotNull PsiDirectory resourceDirectory, @NotNull String subdirName, @Nullable String rootElement) {
                PsiDirectory resSubdir = resourceDirectory.findSubdirectory(subdirName);
                if (resSubdir == null) {
                    resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> resourceDirectory.createSubdirectory(subdirName));
                }
                CreateResourceFileAction.this.myRootElement = rootElement;
                return new CreateResourceActionBase.MyInputValidator(project, resSubdir);
            }
        };
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        CreateTypedResourceFileAction action = this.getActionByDir(directory);
        if (action == null) {
            throw new IllegalArgumentException("Incorrect directory");
        }
        if (this.myRootElement != null && !this.myRootElement.isEmpty()) {
            return action.doCreateAndNavigate(newName, directory, this.myRootElement, false, this.myNavigate);
        }
        return action.create(newName, directory);
    }

    private CreateTypedResourceFileAction getActionByDir(PsiDirectory directory) {
        String baseDirName = directory.getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)baseDirName);
        if (folderType == null) {
            return null;
        }
        return this.mySubactions.get(folderType);
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return CreateResourceFileAction.doGetActionName(directory, newName);
    }

    static String doGetActionName(PsiDirectory directory, String newName) {
        if (FileUtilRt.getExtension((String)newName).isEmpty()) {
            newName = newName + ".xml";
        }
        return AndroidBundle.message("new.resource.action.name", directory.getName() + File.separator + newName);
    }
}

