/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.augment.AndroidInternalRClass;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiElementFinder
extends PsiElementFinder {
    public static final String INTERNAL_PACKAGE_QNAME = "com.android.internal";
    public static final String INTERNAL_R_CLASS_QNAME = "com.android.internal.R";
    private final Object myLock = new Object();
    private final Map<Sdk, SoftReference<PsiClass>> myInternalRClasses = new HashMap();

    public AndroidPsiElementFinder(@NotNull Project project) {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Adapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void jdkRemoved(Sdk sdk) {
                Object object = AndroidPsiElementFinder.this.myLock;
                synchronized (object) {
                    AndroidPsiElementFinder.this.myInternalRClasses.remove(sdk);
                }
            }
        });
    }

    private boolean processInternalRClasses(@NotNull Project project, @NotNull GlobalSearchScope scope, Processor<PsiClass> processor) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            PsiClass internalRClass;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            AndroidPlatform platform = sdk == null ? null : AndroidPlatform.getInstance(sdk);
            PsiClass psiClass = internalRClass = platform == null ? null : this.getOrCreateInternalRClass(project, sdk, platform);
            if (internalRClass == null || !scope.contains(internalRClass.getContainingFile().getViewProvider().getVirtualFile()) || processor.process((Object)internalRClass)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] classes = this.findClasses(qualifiedName, scope);
        return classes.length == 0 ? null : classes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiClass getOrCreateInternalRClass(Project project, Sdk sdk, AndroidPlatform platform) {
        Object object = this.myLock;
        synchronized (object) {
            PsiClass internalRClass = (PsiClass)SoftReference.dereference((Reference)((Reference)this.myInternalRClasses.get(sdk)));
            if (internalRClass == null) {
                internalRClass = new AndroidInternalRClass(PsiManager.getInstance((Project)project), platform, sdk);
                this.myInternalRClasses.put(sdk, (SoftReference<PsiClass>)new SoftReference((Object)internalRClass));
            }
            return internalRClass;
        }
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Project project = scope.getProject();
        if (project == null || !ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (INTERNAL_R_CLASS_QNAME.equals(qualifiedName)) {
            CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
            this.processInternalRClasses(project, scope, (Processor<PsiClass>)processor);
            Collection results = processor.getResults();
            return results.isEmpty() ? PsiClass.EMPTY_ARRAY : results.toArray(new PsiClass[results.size()]);
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        String shortName = qualifiedName.substring(lastDot + 1);
        String parentName = qualifiedName.substring(0, lastDot);
        if (shortName.isEmpty() || !parentName.endsWith(".R")) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        for (PsiClass parentClass : JavaPsiFacade.getInstance((Project)project).findClasses(parentName, scope)) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)parentClass.findInnerClassByName(shortName, false));
        }
        return result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (INTERNAL_PACKAGE_QNAME.equals(psiPackage.getQualifiedName())) {
            return Collections.singleton("R");
        }
        return Collections.emptySet();
    }
}

