/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ClassesAndJarsValidityState
implements ValidityState {
    private Map<String, Long> myFiles = new HashMap<String, Long>();

    private void fillMap(VirtualFile file, Set<VirtualFile> visited) {
        if (file.isDirectory() && visited.add(file)) {
            for (VirtualFile child : file.getChildren()) {
                this.fillMap(child, visited);
            }
        } else if ((StdFileTypes.CLASS.equals(file.getFileType()) || file.getFileType() instanceof ArchiveFileType) && file.isValid()) {
            this.myFiles.put(file.getPath(), file.getTimeStamp());
        }
    }

    public ClassesAndJarsValidityState(@NotNull Collection<VirtualFile> files) {
        HashSet visited = new HashSet();
        for (VirtualFile file : files) {
            this.fillMap(file, (Set<VirtualFile>)visited);
        }
    }

    public ClassesAndJarsValidityState(@NotNull DataInput in) throws IOException {
        int size = in.readInt();
        while (size-- > 0) {
            String path = CompilerIOUtil.readString((DataInput)in);
            long timestamp = in.readLong();
            this.myFiles.put(path, timestamp);
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        return otherState instanceof ClassesAndJarsValidityState && this.myFiles.equals(((ClassesAndJarsValidityState)otherState).myFiles);
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myFiles.size());
        for (String dependency : this.myFiles.keySet()) {
            CompilerIOUtil.writeString((String)dependency, (DataOutput)out);
            out.writeLong(this.myFiles.get(dependency));
        }
    }
}

