/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.apk.ApkFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSourceAutogenerating
extends AndroidFacetScopedService {
    private static final Key<ModuleSourceAutogenerating> KEY = Key.create((String)ModuleSourceAutogenerating.class.getName());
    private final Set<AndroidAutogeneratorMode> myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
    @GuardedBy(value="myAutogeneratedFiles")
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles = new HashMap<AndroidAutogeneratorMode, Set<String>>();

    @Nullable
    public static ModuleSourceAutogenerating getInstance(@NotNull AndroidFacet facet) {
        return (ModuleSourceAutogenerating)facet.getUserData(KEY);
    }

    public static void initialize(@NotNull AndroidFacet facet) {
        if (facet.requiresAndroidModel()) {
            return;
        }
        if (ApkFacet.getInstance(facet.getModule()) != null) {
            return;
        }
        ModuleSourceAutogenerating autogenerating = new ModuleSourceAutogenerating(facet);
        facet.putUserData(KEY, autogenerating);
        Module module = facet.getModule();
        Project project = module.getProject();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (facet.isDisposed() || module.isDisposed() || project.isDisposed()) {
                return;
            }
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.RENDERSCRIPT);
            AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.BUILDCONFIG);
        });
    }

    private ModuleSourceAutogenerating(@NotNull AndroidFacet facet) {
        super(facet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = new HashSet<String>();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            return set != null ? new HashSet<String>(set) : Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRegeneratingState() {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            Collections.addAll(this.myDirtyModes, AndroidAutogeneratorMode.values());
        }
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

