/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import java.util.EnumSet;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiRootFileDescription<T extends DomElement>
extends AndroidResourceDomFileDescription<T> {
    private final ImmutableSet<String> myTagNames;

    public AbstractMultiRootFileDescription(@NotNull Class<T> aClass, @NotNull EnumSet<ResourceFolderType> resourceFolderTypes, @NotNull ImmutableSet<String> tagNames) {
        super(aClass, (String)tagNames.iterator().next(), resourceFolderTypes);
        this.myTagNames = tagNames;
    }

    public AbstractMultiRootFileDescription(@NotNull Class<T> aClass, @NotNull ResourceFolderType resourceFolderType, @NotNull ImmutableSet<String> tagNames) {
        this(aClass, EnumSet.of(resourceFolderType), tagNames);
    }

    public AbstractMultiRootFileDescription(@NotNull Class<T> aClass, @NotNull ResourceFolderType resourceFolderType, String ... tagNames) {
        this(aClass, resourceFolderType, (ImmutableSet<String>)ImmutableSet.copyOf((Object[])tagNames));
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (!super.isMyFile(file, module)) {
            return false;
        }
        XmlTag rootTag = file.getRootTag();
        return rootTag != null && this.myTagNames.contains((Object)rootTag.getName());
    }
}

