/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSingleRootFileDescription<T extends DomElement>
extends AndroidResourceDomFileDescription<T> {
    private final String myTagName;

    public AbstractSingleRootFileDescription(@NotNull Class<T> aClass, @NotNull String tagName, @NotNull ResourceFolderType resourceFolderType) {
        super(aClass, tagName, resourceFolderType);
        this.myTagName = tagName;
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (!super.isMyFile(file, module)) {
            return false;
        }
        XmlTag rootTag = file.getRootTag();
        if (rootTag == null) {
            return false;
        }
        return this.myTagName.equals(rootTag.getName());
    }
}

