/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.android.dom.FileDescriptionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    protected final EnumSet<ResourceFolderType> myResourceType;

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull EnumSet<ResourceFolderType> resourceTypes) {
        super(rootElementClass, rootTagName, new String[0]);
        this.myResourceType = EnumSet.copyOf(resourceTypes);
    }

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, @NotNull ResourceFolderType resourceType) {
        this(rootElementClass, rootTagName, EnumSet.of(resourceType));
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        for (ResourceFolderType folderType : this.myResourceType) {
            if (!AndroidResourceDomFileDescription.doIsMyFile(file, folderType)) continue;
            return true;
        }
        return false;
    }

    public static boolean doIsMyFile(@NotNull XmlFile file, @NotNull ResourceFolderType folderType) {
        return FileDescriptionUtils.isResourceOfType(file, folderType, Collections.emptySet());
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }

    @NotNull
    public EnumSet<ResourceFolderType> getResourceTypes() {
        return this.myResourceType;
    }
}

