/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public final class FileDescriptionUtils {
    private FileDescriptionUtils() {
    }

    public static boolean isResourceOfType(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newIsResourceOfTypeComputable(file, folderType, rootTags));
    }

    @NotNull
    static Computable<Boolean> newIsResourceOfTypeComputable(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return () -> {
            if (file.getProject().isDisposed()) {
                return false;
            }
            if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, folderType.getName())) {
                return false;
            }
            if (rootTags.isEmpty()) {
                return true;
            }
            XmlTag rootTag = file.getRootTag();
            assert (rootTag != null);
            return rootTags.contains(rootTag.getName());
        };
    }
}

