/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinition
implements Cloneable {
    private String myName;
    private final List<String> myParentStyleables;
    private final Set<AttributeFormat> myFormats;
    private LinkedList<String> myValues;
    private final Map<String, String> myStyleable2DocValue;
    private HashMap<String, String> myValueDoc;
    private HashMap<String, Integer> myValueMappings;
    private String myGlobalDocValue;
    private String myAttrGroup;
    private final String myLibraryName;

    public AttributeDefinition(@NotNull String name) {
        this(name, null, null, Collections.emptySet());
    }

    public AttributeDefinition(@NotNull String name, @Nullable String libraryName, @Nullable String parentStyleableName, @NotNull Collection<AttributeFormat> formats) {
        this.myName = name;
        this.myLibraryName = libraryName;
        this.myParentStyleables = parentStyleableName == null ? ContainerUtil.newSmartList() : ContainerUtil.newSmartList((Object)parentStyleableName);
        this.myFormats = formats.isEmpty() ? EnumSet.noneOf(AttributeFormat.class) : EnumSet.copyOf(formats);
        this.myStyleable2DocValue = new HashMap<String, String>();
    }

    public void addValue(@NotNull String name) {
        if (this.myValues == null) {
            this.myValues = new LinkedList();
        }
        this.myValues.add(name);
    }

    public void addValueMapping(@NotNull String flagName, @NotNull Integer intValue) {
        if (this.myValueMappings == null) {
            this.myValueMappings = new HashMap();
        }
        this.myValueMappings.put(flagName, intValue);
    }

    @Nullable
    public Integer getValueMapping(@NotNull String flagName) {
        return this.myValueMappings != null ? this.myValueMappings.get(flagName) : null;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    @NotNull
    public List<String> getParentStyleables() {
        return this.myParentStyleables;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        return Collections.unmodifiableSet(this.myFormats);
    }

    @Nullable
    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    public void setAttrGroup(@Nullable String attrGroup) {
        this.myAttrGroup = attrGroup;
    }

    public void addFormats(@NotNull Collection<AttributeFormat> format) {
        this.myFormats.addAll(format);
    }

    @NotNull
    public String[] getValues() {
        return this.myValues == null ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(this.myValues);
    }

    @Nullable
    public String getDocValue(@Nullable String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(@NotNull String docValue, @Nullable String parentStyleable) {
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }

    public void addValueDoc(@NotNull String value, @NotNull String doc) {
        if (this.myValueDoc == null) {
            this.myValueDoc = new HashMap();
        }
        this.myValueDoc.put(value, doc);
    }

    @Nullable
    public String getValueDoc(@NotNull String value) {
        return this.myValueDoc != null ? this.myValueDoc.get(value) : null;
    }

    public boolean isAttributeDeprecated() {
        String doc = this.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    public boolean isValueDeprecated(@NotNull String value) {
        String doc = this.getValueDoc(value);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    @NotNull
    public AttributeDefinition cloneWithName(@NotNull String name) {
        try {
            AttributeDefinition copy = (AttributeDefinition)super.clone();
            copy.myName = name;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

