/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.lang.databinding.DataBindingXmlReferenceContributor;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingConverter
extends ResolvingConverter<PsiElement>
implements CustomReferenceConverter<PsiElement> {
    @NotNull
    protected static String resolveImport(@NotNull String className, @Nullable DataBindingInfo dataBindingInfo) {
        String firstSegment;
        String importedType;
        int dotOffset;
        if (dataBindingInfo != null && (dotOffset = className.indexOf(46)) != 0 && (importedType = DataBindingConverter.getImport(firstSegment = dotOffset >= 0 ? className.substring(0, dotOffset) : className, dataBindingInfo)) != null) {
            return dotOffset >= 0 ? importedType + className.substring(dotOffset) : importedType;
        }
        return className;
    }

    private static String getImport(@NotNull String alias, @NotNull ConvertContext context) {
        DataBindingInfo bindingInfo = DataBindingConverter.getDataBindingInfo(context);
        if (bindingInfo == null) {
            return null;
        }
        return DataBindingConverter.getImport(alias, bindingInfo);
    }

    private static String getImport(String name, DataBindingInfo dataBindingInfo) {
        for (PsiDataBindingResourceItem importItem : dataBindingInfo.getItems(DataBindingResourceType.IMPORT)) {
            String alias = DataBindingUtil.getAlias(importItem);
            if (alias == null) {
                String importedType = importItem.getTypeDeclaration();
                if (importedType == null || !importedType.endsWith(name) || importedType.length() <= name.length() + 1 || importedType.charAt(importedType.length() - name.length()) != '.') continue;
                return importedType;
            }
            if (!name.equals(alias)) continue;
            return importItem.getTypeDeclaration();
        }
        return null;
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        return Collections.emptyList();
    }

    @Nullable
    public PsiElement fromString(@Nullable @NonNls String type, ConvertContext context) {
        if (type == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        DataBindingInfo dataBindingInfo = DataBindingConverter.getDataBindingInfo(context);
        String qualifiedName = DataBindingConverter.resolveImport(type, dataBindingInfo);
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        if (!qualifiedName.isEmpty() && qualifiedName.indexOf(46) < 0) {
            if (Character.isLowerCase(qualifiedName.charAt(0))) {
                PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)qualifiedName);
                if (primitiveType != null) {
                    PsiClassType boxedType = primitiveType.getBoxedType(PsiManager.getInstance((Project)project), scope);
                    if (boxedType != null) {
                        return boxedType.resolve();
                    }
                    return null;
                }
            } else {
                PsiClass aClass = psiFacade.findClass("java.lang." + qualifiedName, scope);
                if (aClass != null) {
                    return aClass;
                }
            }
        }
        return psiFacade.findClass(qualifiedName, scope);
    }

    @Nullable
    public String toString(@Nullable PsiElement element, ConvertContext context) {
        if (element instanceof PsiClass) {
            DataBindingInfo dataBindingInfo;
            String type = ((PsiClass)element).getQualifiedName();
            if (type != null && (dataBindingInfo = DataBindingConverter.getDataBindingInfo(context)) != null) {
                type = DataBindingConverter.unresolveImport(type, dataBindingInfo);
            }
            return type;
        }
        if (element instanceof PsiTypeElement) {
            return ((PsiTypeElement)element).getType().getCanonicalText();
        }
        return null;
    }

    private static String unresolveImport(String className, DataBindingInfo dataBindingInfo) {
        List<String> segments = StringUtil.split((String)className, (String)".");
        if (!segments.isEmpty()) {
            String alias = null;
            int maxMatchedSegments = 0;
            for (PsiDataBindingResourceItem psiImport : dataBindingInfo.getItems(DataBindingResourceType.IMPORT)) {
                String importedType = psiImport.getTypeDeclaration();
                int matchedSegments = DataBindingConverter.getNumberOfMatchedSegments(importedType, segments);
                if (matchedSegments <= maxMatchedSegments) continue;
                maxMatchedSegments = matchedSegments;
                alias = psiImport.getExtra("alias");
            }
            if (maxMatchedSegments != 0 && alias != null) {
                segments = segments.subList(maxMatchedSegments - 1, segments.size());
                segments.set(0, alias);
                return StringUtil.join(segments, (String)".");
            }
        }
        return className;
    }

    private static int getNumberOfMatchedSegments(String str, List<String> qName) {
        int offset = 0;
        for (int i = 0; i < qName.size(); ++i) {
            String segment = qName.get(i);
            int endOffset = offset + segment.length();
            if (!str.regionMatches(offset, segment, 0, segment.length()) || endOffset != str.length() && str.charAt(endOffset) != '.') {
                return i;
            }
            offset = endOffset + 1;
        }
        return qName.size();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value, PsiElement element, ConvertContext context) {
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = attrValue.getValue();
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        int startOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DataBindingConverter.createReferences(element, strValue, false, startOffset, context, result);
        return result.toArray(new PsiReference[result.size()]);
    }

    protected static void createReferences(PsiElement element, String className, boolean resolveType, int startOffset, ConvertContext context, List<PsiReference> result) {
        TextRange range;
        String importedType;
        Module module = context.getModule();
        if (module == null) {
            return;
        }
        int offset = startOffset;
        List nameParts = StringUtil.split((String)className, (String)".");
        if (nameParts.isEmpty()) {
            return;
        }
        int idx = 0;
        String alias = (String)nameParts.get(idx);
        String string = importedType = resolveType ? DataBindingConverter.getImport(alias, context) : null;
        if (importedType != null) {
            ++idx;
            TextRange range2 = new TextRange(offset, offset += alias.length());
            ++offset;
            result.add((PsiReference)new AliasedReference(element, range2, importedType, module));
        } else if (nameParts.size() == 1 && !alias.isEmpty()) {
            if (Character.isLowerCase(alias.charAt(0))) {
                PsiPrimitiveType primitive = PsiJavaParserFacadeImpl.getPrimitiveType((String)alias);
                if (primitive != null) {
                    result.add((PsiReference)new PsiReferenceBase.Immediate(element, true, element));
                }
            } else {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang." + alias, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
                if (psiClass != null) {
                    range = new TextRange(offset, offset += alias.length());
                    result.add((PsiReference)new ClassReference(element, range, (PsiElement)psiClass));
                }
            }
            ++idx;
        }
        while (idx < nameParts.size()) {
            String packageName = (String)nameParts.get(idx);
            if (!packageName.isEmpty()) {
                range = new TextRange(offset, offset += packageName.length());
                result.add((PsiReference)new AliasedReference(element, range, String.join((CharSequence)".", nameParts.subList(0, idx + 1)), module));
            }
            ++idx;
            ++offset;
        }
    }

    @Nullable
    protected static DataBindingInfo getDataBindingInfo(@NotNull ConvertContext context) {
        return DataBindingXmlReferenceContributor.getDataBindingInfo((PsiElement)context.getFile());
    }

    private static class ClassReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final PsiElement myResolveTo;

        public ClassReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull PsiElement resolveTo) {
            super(element, range, true);
            this.myResolveTo = resolveTo;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            return this.myResolveTo;
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private static class AliasedReference
    extends PsiReferenceBase<PsiElement> {
        private final String myReferenceTo;
        private final Module myModule;

        public AliasedReference(PsiElement referenceFrom, TextRange range, String referenceTo, Module module) {
            super(referenceFrom, range, true);
            this.myReferenceTo = referenceTo;
            this.myModule = module;
        }

        @Nullable
        public PsiElement resolve() {
            ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
            return (PsiElement)cache.resolveWithCaching((PsiReference)this, (psiReference, incompleteCode) -> this.resolveInner(), false, false);
        }

        private PsiElement resolveInner() {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            PsiPackage aPackage = facade.findPackage(this.myReferenceTo);
            if (aPackage != null) {
                return aPackage;
            }
            PsiClass aClass = facade.findClass(this.myReferenceTo, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope());
            if (aClass != null) {
                return aClass;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @NotNull
        public String getCanonicalText() {
            return this.myReferenceTo;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)element;
                String newName = psiClass.getQualifiedName();
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                if (manipulator != null) {
                    return manipulator.handleContentChange(this.myElement, newName);
                }
            }
            return super.bindToElement(element);
        }
    }
}

