/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationDomFileDescription
extends AndroidResourceDomFileDescription<NavDestinationElement> {
    private static final String DEFAULT_ROOT_TAG = "navigation";

    public NavigationDomFileDescription() {
        super(NavDestinationElement.class, DEFAULT_ROOT_TAG, ResourceFolderType.NAVIGATION);
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        return NavigationDomFileDescription.isNavFile(file);
    }

    public static boolean isNavFile(@NotNull XmlFile file) {
        if (file.getName().equals("mobile_navigation.xml")) {
            return true;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> AndroidResourceDomFileDescription.doIsMyFile(file, ResourceFolderType.NAVIGATION));
    }
}

