/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.ClassMaps;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.NavActionElement;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationSchema
implements Disposable {
    public static final String TAG_ACTION = "action";
    public static final String ATTR_DESTINATION = "destination";
    public static final String TAG_INCLUDE = "include";
    public static final String NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.Navigator";
    public static final String NAV_GRAPH_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.NavGraphNavigator";
    public static final String FRAGMENT_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.FragmentNavigator";
    public static final String ACTIVITY_NAVIGATOR_CLASS_NAME = "android.support.navigation.app.nav.ActivityNavigator";
    public static final Map<String, DestinationType> NAV_CLASS_TO_TYPE = ImmutableMap.of((Object)"android.support.navigation.app.nav.NavGraphNavigator", (Object)((Object)DestinationType.NAVIGATION), (Object)"android.support.navigation.app.nav.FragmentNavigator", (Object)((Object)DestinationType.FRAGMENT), (Object)"android.support.navigation.app.nav.ActivityNavigator", (Object)((Object)DestinationType.ACTIVITY));
    public static final String ANNOTATION_NAV_TAG_NAME = "android.support.navigation.app.nav.Navigator.Name";
    public static final String ATTR_NAV_TYPE = "navType";
    public static final String ATTR_START_DESTINATION = "startDestination";
    public static final Map<String, DestinationType> DESTINATION_SUPERCLASS_TO_TYPE = ImmutableMap.of((Object)"android.app.Activity", (Object)((Object)DestinationType.ACTIVITY), (Object)"android.app.Fragment", (Object)((Object)DestinationType.FRAGMENT), (Object)"android.support.v4.app.Fragment", (Object)((Object)DestinationType.FRAGMENT));
    private static final Map<AndroidFacet, NavigationSchema> ourSchemas = new HashMap<AndroidFacet, NavigationSchema>();
    private Map<String, DestinationType> myTagToDestinationType;
    private Map<DestinationType, String> myTypeToRootTag;
    private Map<DestinationType, Map<String, PsiClass>> myNavTagToClass;
    private final ClassMaps myClassMaps;

    @NotNull
    public static NavigationSchema getOrCreateSchema(@NotNull AndroidFacet facet) {
        NavigationSchema result = ourSchemas.get((Object)facet);
        if (result == null) {
            result = new NavigationSchema(facet);
            ourSchemas.put(facet, result);
            Disposer.register((Disposable)facet, (Disposable)result);
        }
        return result;
    }

    private NavigationSchema(@NotNull AndroidFacet facet) {
        this.myClassMaps = ClassMaps.getInstance(facet);
    }

    public void dispose() {
        ourSchemas.remove((Object)this.myClassMaps.getFacet());
    }

    @Nullable
    public PsiClass getDestinationClassByTag(@NotNull String tagName) {
        for (Map<String, PsiClass> typeMap : this.getTypeTagClassMap().values()) {
            PsiClass c = typeMap.get(tagName);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @NotNull
    private Map<DestinationType, Map<String, PsiClass>> getTypeTagClassMap() {
        this.initIfNeeded();
        return this.myNavTagToClass;
    }

    @NotNull
    public Map<String, PsiClass> getDestinationClassByTagMap(@NotNull DestinationType type) {
        this.initIfNeeded();
        return this.myNavTagToClass.get((Object)type);
    }

    @NotNull
    private Map<String, PsiClass> getClassMap(@NotNull String className) {
        Map<String, PsiClass> result = this.myClassMaps.getClassMap(className);
        if (result.isEmpty()) {
            throw new RuntimeException();
        }
        return result;
    }

    private void initIfNeeded() {
        if (this.myNavTagToClass == null) {
            HashMap<DestinationType, Map<String, PsiClass>> result = new HashMap<DestinationType, Map<String, PsiClass>>();
            HashMap<String, DestinationType> tagToType = new HashMap<String, DestinationType>();
            HashMap<DestinationType, Map<String, PsiClass>> classNameMaps = new HashMap<DestinationType, Map<String, PsiClass>>();
            for (Map.Entry<String, DestinationType> entry : NAV_CLASS_TO_TYPE.entrySet()) {
                classNameMaps.put(entry.getValue(), this.getClassMap(entry.getKey()));
                result.put(entry.getValue(), new HashMap());
            }
            result.put(DestinationType.OTHER, new HashMap());
            Map<String, PsiClass> map = this.getClassMap(NAVIGATOR_CLASS_NAME);
            for (String className : map.keySet()) {
                PsiClass c = map.get(className);
                for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)c, (boolean)false, null)) {
                    String value;
                    if (!ANNOTATION_NAV_TAG_NAME.equals(annotation.getQualifiedName()) || (value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value")) == null) continue;
                    DestinationType resolvedType = null;
                    for (DestinationType type : classNameMaps.keySet()) {
                        Map classNameMap = (Map)classNameMaps.get((Object)type);
                        if (!classNameMap.containsKey(className)) continue;
                        resolvedType = type;
                        break;
                    }
                    if (resolvedType == null) {
                        resolvedType = DestinationType.OTHER;
                    }
                    ((Map)result.get((Object)resolvedType)).put(value, c);
                    tagToType.put(value, resolvedType);
                }
            }
            this.myNavTagToClass = result;
            this.myTagToDestinationType = tagToType;
            HashMap<DestinationType, String> hashMap = new HashMap<DestinationType, String>();
            HashMap<DestinationType, PsiClass> typeToBestClass = new HashMap<DestinationType, PsiClass>();
            for (String tag : this.myTagToDestinationType.keySet()) {
                DestinationType type = this.myTagToDestinationType.get(tag);
                PsiClass psiClass = this.myNavTagToClass.get((Object)type).get(tag);
                if (typeToBestClass.containsKey((Object)type) && !((PsiClass)typeToBestClass.get((Object)type)).isInheritor(psiClass, true)) continue;
                typeToBestClass.put(type, psiClass);
                hashMap.put(type, tag);
            }
            this.myTypeToRootTag = hashMap;
        }
    }

    @NotNull
    public Multimap<Class<? extends AndroidDomElement>, String> getDestinationSubtags(@NotNull String tagName) {
        this.initIfNeeded();
        HashMultimap result = HashMultimap.create();
        if (this.myTagToDestinationType.get(tagName) == DestinationType.NAVIGATION) {
            for (Map<String, PsiClass> typeMap : this.getTypeTagClassMap().values()) {
                for (String subTag : typeMap.keySet()) {
                    result.put(NavDestinationElement.class, (Object)subTag);
                }
            }
        }
        result.put(NavActionElement.class, (Object)TAG_ACTION);
        return result;
    }

    @Nullable
    public DestinationType getDestinationType(@NotNull String tag) {
        this.initIfNeeded();
        return this.myTagToDestinationType.get(tag);
    }

    @Nullable
    public String getTag(@NotNull DestinationType type) {
        this.initIfNeeded();
        return this.myTypeToRootTag.get((Object)type);
    }

    @Nullable
    public String getTagForComponentSuperclass(@NotNull String superclassName) {
        this.initIfNeeded();
        DestinationType type = DESTINATION_SUPERCLASS_TO_TYPE.get(superclassName);
        if (type != null) {
            return this.getTag(type);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public String findTagForComponent(@Nullable PsiClass layoutClass) {
        while (layoutClass != null) {
            String tag;
            String qName = layoutClass.getQualifiedName();
            if (qName != null && (tag = this.getTagForComponentSuperclass(qName)) != null) {
                return tag;
            }
            layoutClass = layoutClass.getSuperClass();
        }
        return null;
    }

    public static enum DestinationType {
        NAVIGATION,
        FRAGMENT,
        ACTIVITY,
        OTHER;

    }
}

