/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameConverter
extends ResolvingConverter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (this.getErrorMessage(s, context) != null) {
            return null;
        }
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        ResourceType type = null;
        XmlTag tag = context.getTag();
        if (tag != null && "attr".equals(tag.getName())) {
            type = ResourceType.ATTR;
        }
        return s == null ? null : ValueResourceNameValidator.getErrorText((String)s, type);
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        if (!(element instanceof GenericAttributeValue)) {
            return Collections.emptyList();
        }
        if (element.getParent() instanceof Style) {
            return ResourceNameConverter.getStyleNameVariants(context, (GenericAttributeValue)element);
        }
        return Collections.emptyList();
    }

    private static Collection<String> getStyleNameVariants(ConvertContext context, GenericAttributeValue element) {
        Module module = context.getModule();
        if (module == null) {
            return Collections.emptyList();
        }
        LocalResourceManager manager = LocalResourceManager.getInstance(module);
        if (manager == null) {
            return Collections.emptyList();
        }
        Collection<String> styleNames = manager.getResourceNames(ResourceType.STYLE);
        ArrayList<String> result = new ArrayList<String>();
        String currentValue = element.getStringValue();
        for (String name : styleNames) {
            if (currentValue != null && currentValue.startsWith(name)) continue;
            result.add(name + '.');
        }
        return result;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        DomElement parent = value.getParent();
        if (parent instanceof Style) {
            return ResourceNameConverter.getReferencesInStyleName((Style)parent, value, facet);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferencesInStyleName(@NotNull Style style, @NotNull GenericDomValue<String> value, @NotNull AndroidFacet facet) {
        String s = value.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String[] ids = s.split("\\.");
        if (ids.length < 2 || style.getParentStyle().getStringValue() != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MyParentStyleReference> result = new ArrayList<MyParentStyleReference>(ids.length - 1);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            if (i < ids.length - 1) {
                String parentStyleName = s.substring(0, offset);
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), parentStyleName);
                result.add(new MyParentStyleReference(value, new TextRange(1, 1 + offset), val, facet));
                if (ResourceNameConverter.hasExplicitParent(facet, parentStyleName)) break;
            }
            offset = offset - ids[i].length() - 1;
        }
        return result.toArray(new PsiReference[result.size()]);
    }

    public static boolean hasExplicitParent(@NotNull AndroidFacet facet, @NotNull String localStyleName) {
        LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
        List<ValueResourceInfoImpl> styles = resourceManager.findValueResourceInfos(ResourceType.STYLE.getName(), localStyleName, true, false);
        if (styles.isEmpty()) {
            return false;
        }
        for (ValueResourceInfoImpl info : styles) {
            ResourceElement domElement = info.computeDomElement();
            if (domElement instanceof Style && ((Style)domElement).getParentStyle().getStringValue() != null) continue;
            return false;
        }
        return true;
    }

    public static class MyParentStyleReference
    extends AndroidResourceReferenceBase
    implements LocalQuickFixProvider {
        public MyParentStyleReference(@NotNull GenericDomValue value, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet) {
            super(value, range, resourceValue, facet);
        }

        public LocalQuickFix[] getQuickFixes() {
            String resourceName = this.getValue();
            if (resourceName.isEmpty()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiFile psiFile = ((XmlElement)this.getElement()).getContainingFile();
            if (psiFile == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new CreateValueResourceQuickFix(this.myFacet, ResourceType.STYLE, resourceName, psiFile, false)};
        }
    }
}

