/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceElementWrapper
implements PsiFile,
ResourceElementWrapper,
PsiElementNavigationItem {
    private final PsiFile myWrappee;
    private final PsiDirectory myResourceDir;

    public FileResourceElementWrapper(@NotNull PsiFile wrappeeElement) {
        this.myWrappee = wrappeeElement;
        this.myResourceDir = this.getContainingFile().getContainingDirectory();
    }

    @Override
    public PsiElement getWrappee() {
        return this.myWrappee;
    }

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException {
        return this.myWrappee.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return this.myWrappee.getLanguage();
    }

    public PsiManager getManager() {
        return this.myWrappee.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.myWrappee.getChildren();
    }

    public VirtualFile getVirtualFile() {
        return this.myWrappee.getVirtualFile();
    }

    public PsiDirectory getContainingDirectory() {
        return this.myWrappee.getContainingDirectory();
    }

    public boolean isDirectory() {
        return this.myWrappee.isDirectory();
    }

    public PsiDirectory getParent() {
        return this.myWrappee.getParent();
    }

    public long getModificationStamp() {
        return this.myWrappee.getModificationStamp();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this.myWrappee.getOriginalFile();
    }

    @NotNull
    public FileType getFileType() {
        return this.myWrappee.getFileType();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        return this.myWrappee.getPsiRoots();
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        return this.myWrappee.getViewProvider();
    }

    @Nullable
    public PsiElement getFirstChild() {
        return this.myWrappee.getFirstChild();
    }

    @Nullable
    public PsiElement getLastChild() {
        return this.myWrappee.getLastChild();
    }

    @Nullable
    public PsiElement getNextSibling() {
        return this.myWrappee.getNextSibling();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        return this.myWrappee.getPrevSibling();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this.myWrappee.getContainingFile();
    }

    public TextRange getTextRange() {
        return this.myWrappee.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myWrappee.getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.myWrappee.getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.myWrappee.findElementAt(offset);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        return this.myWrappee.findReferenceAt(offset);
    }

    public int getTextOffset() {
        return this.myWrappee.getTextOffset();
    }

    @NonNls
    public String getText() {
        return this.myWrappee.getText();
    }

    @NotNull
    public char[] textToCharArray() {
        return this.myWrappee.textToCharArray();
    }

    public PsiElement getNavigationElement() {
        return this.myWrappee.getNavigationElement();
    }

    public PsiElement getOriginalElement() {
        return this.myWrappee.getOriginalElement();
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text) {
        return this.myWrappee.textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        return this.myWrappee.textMatches(element);
    }

    public boolean textContains(char c) {
        return this.myWrappee.textContains(c);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        this.myWrappee.accept(visitor);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        this.myWrappee.acceptChildren(visitor);
    }

    public PsiElement copy() {
        return this.myWrappee.copy();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.myWrappee.add(element);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addAfter(element, anchor);
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        this.myWrappee.checkAdd(element);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.myWrappee.addRange(first, last);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappee.addRangeAfter(first, last, anchor);
    }

    public void delete() throws IncorrectOperationException {
        this.myWrappee.delete();
    }

    public void checkDelete() throws IncorrectOperationException {
        this.myWrappee.checkDelete();
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.myWrappee.deleteChildRange(first, last);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return this.myWrappee.replace(newElement);
    }

    public boolean isValid() {
        return this.myWrappee.isValid();
    }

    public boolean isWritable() {
        return this.myWrappee.isWritable();
    }

    @Nullable
    public PsiReference getReference() {
        return this.myWrappee.getReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        return this.myWrappee.getReferences();
    }

    @Nullable
    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.myWrappee.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        this.myWrappee.putCopyableUserData(key, value);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return this.myWrappee.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myWrappee.getContext();
    }

    public boolean isPhysical() {
        return false;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myWrappee.getResolveScope();
    }

    @NotNull
    public SearchScope getUseScope() {
        return this.myWrappee.getUseScope();
    }

    @Nullable
    public FileASTNode getNode() {
        return this.myWrappee.getNode();
    }

    public void subtreeChanged() {
        this.myWrappee.subtreeChanged();
    }

    @NonNls
    public String toString() {
        return this.myWrappee.toString();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof FileResourceElementWrapper) {
            another = ((FileResourceElementWrapper)another).getWrappee();
        }
        return this.myWrappee == another || this.myWrappee.isEquivalentTo(another);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myWrappee.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myWrappee.putUserData(key, value);
    }

    public Icon getIcon(int flags) {
        return this.myWrappee.getIcon(flags);
    }

    @NotNull
    public String getName() {
        return this.myWrappee.getName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.myWrappee.setName(name);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return this.myWrappee.processChildren(processor);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = FileResourceElementWrapper.this.myWrappee.getName();
                if (FileResourceElementWrapper.this.myResourceDir == null) {
                    return name;
                }
                return name + " (" + FileResourceElementWrapper.this.myResourceDir.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        this.myWrappee.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myWrappee.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myWrappee.canNavigateToSource();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        this.myWrappee.checkSetName(name);
    }

    public PsiElement getTargetElement() {
        return this.myWrappee;
    }
}

