/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidRunConfigurations;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFrameworkDetector
extends FacetBasedFrameworkDetector<AndroidFacet, AndroidFacetConfiguration> {
    private static final NotificationGroup ANDROID_MODULE_IMPORTING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Module Importing");

    public AndroidFrameworkDetector() {
        super("android");
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        GradleProjectInfo gradleProjectInfo;
        Project project = context.getProject();
        if (project != null && ((gradleProjectInfo = GradleProjectInfo.getInstance(project)).isBuildWithGradle() || gradleProjectInfo.hasTopLevelGradleBuildFile())) {
            return Collections.emptyList();
        }
        return super.detect(newFiles, context);
    }

    public void setupFacet(@NotNull AndroidFacet facet, ModifiableRootModel model) {
        Module module = facet.getModule();
        Project project = module.getProject();
        VirtualFile[] contentRoots = model.getContentRoots();
        if (contentRoots.length == 1) {
            ((AndroidFacetConfiguration)facet.getConfiguration()).init(module, contentRoots[0]);
        }
        ImportDependenciesUtil.importDependencies(module, true);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> {
            AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet, model);
            ApplicationManager.getApplication().saveAll();
        }));
    }

    public static void doImportSdkAndFacetConfiguration(@NotNull AndroidFacet facet, @Nullable ModifiableRootModel model) {
        Pair<String, VirtualFile> androidProjectTypeProperty;
        Pair<String, VirtualFile> androidLibraryProperty;
        Pair<String, VirtualFile> dexDisableMergerProperty;
        Pair<String, VirtualFile> manifestMergerProperty;
        Module module = facet.getModule();
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(module, true);
        if (model != null && !model.isDisposed() && model.isWritable()) {
            model.setSdk(ModuleRootManager.getInstance((Module)module).getSdk());
        }
        if ((manifestMergerProperty = AndroidRootUtil.getProjectPropertyValue(module, "manifestmerger.enabled")) != null) {
            facet.getProperties().ENABLE_MANIFEST_MERGING = AndroidFrameworkDetector.getFirstAsBoolean(manifestMergerProperty);
        }
        if ((dexDisableMergerProperty = AndroidRootUtil.getProjectPropertyValue(module, "dex.disable.merger")) != null) {
            boolean bl = facet.getProperties().ENABLE_PRE_DEXING = !AndroidFrameworkDetector.getFirstAsBoolean(dexDisableMergerProperty);
        }
        if ((androidLibraryProperty = AndroidRootUtil.getProjectPropertyValue(module, "android.library")) != null && AndroidFrameworkDetector.getFirstAsBoolean(androidLibraryProperty)) {
            facet.setProjectType(1);
        }
        if ((androidProjectTypeProperty = AndroidRootUtil.getProjectPropertyValue(module, "project.type")) != null) {
            facet.setProjectType(Integer.parseInt((String)androidProjectTypeProperty.getFirst()));
        }
        if (facet.isAppProject()) {
            Manifest manifest;
            Pair<String, VirtualFile> dexForceJumboProperty = AndroidRootUtil.getProjectPropertyValue(module, "dex.force.jumbo");
            if (dexForceJumboProperty != null) {
                AndroidFrameworkDetector.showDexOptionNotification(module, "dex.force.jumbo");
            }
            if ((manifest = facet.getManifest()) != null && DefaultActivityLocator.getDefaultLauncherActivityName(module.getProject(), manifest) != null) {
                AndroidRunConfigurations.getInstance().addRunConfiguration(facet, null);
            }
        }
    }

    private static boolean getFirstAsBoolean(@NotNull Pair<String, VirtualFile> pair) {
        return Boolean.parseBoolean((String)pair.getFirst());
    }

    @NotNull
    public static Notification showDexOptionNotification(@NotNull Module module, @NotNull String propertyName) {
        final Project project = module.getProject();
        Notification notification = ANDROID_MODULE_IMPORTING_NOTIFICATION.createNotification(AndroidBundle.message("android.facet.importing.title", module.getName()), "'" + propertyName + "' property is detected in " + "project.properties" + " file.<br>You may enable related option in <a href='configure'>Settings | Compiler | Android DX</a>", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, AndroidBundle.message("android.dex.compiler.configurable.display.name", new Object[0]));
            }
        });
        notification.notify(project);
        return notification;
    }

    @NotNull
    public FacetType<AndroidFacet, AndroidFacetConfiguration> getFacetType() {
        return AndroidFacet.getFacetType();
    }

    @NotNull
    public FileType getFileType() {
        return StdFileTypes.XML;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        return FileContentPattern.fileContent().withName("AndroidManifest.xml");
    }
}

