/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

class LegacySourceProvider
implements SourceProvider {
    @NotNull
    private final AndroidFacet myAndroidFacet;

    LegacySourceProvider(@NotNull AndroidFacet androidFacet) {
        this.myAndroidFacet = androidFacet;
    }

    @NotNull
    public String getName() {
        return "main";
    }

    @NotNull
    public File getManifestFile() {
        Module module = this.myAndroidFacet.getModule();
        VirtualFile manifestFile = AndroidRootUtil.getFileByRelativeModulePath(module, this.myAndroidFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
        if (manifestFile == null) {
            VirtualFile root;
            VirtualFile virtualFile = root = !this.myAndroidFacet.requiresAndroidModel() ? AndroidRootUtil.getMainContentRoot(this.myAndroidFacet) : null;
            if (root != null) {
                return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "AndroidManifest.xml");
            }
            return new File("AndroidManifest.xml");
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile);
    }

    @NotNull
    public Set<File> getJavaDirectories() {
        HashSet dirs = Sets.newHashSet();
        Module module = this.myAndroidFacet.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length != 0) {
            for (VirtualFile root : contentRoots) {
                dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            }
        }
        return dirs;
    }

    @NotNull
    public Set<File> getResourcesDirectories() {
        return Collections.emptySet();
    }

    @NotNull
    public Set<File> getAidlDirectories() {
        VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myAndroidFacet);
        return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
    }

    @NotNull
    public Set<File> getRenderscriptDirectories() {
        VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myAndroidFacet);
        return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
    }

    @NotNull
    public Set<File> getResDirectories() {
        String resRelPath = this.myAndroidFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
        VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myAndroidFacet.getModule(), resRelPath, true);
        return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
    }

    @NotNull
    public Set<File> getAssetsDirectories() {
        VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myAndroidFacet);
        return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
    }

    @NotNull
    public Collection<File> getJniLibsDirectories() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<File> getShadersDirectories() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<File> getCDirectories() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<File> getCppDirectories() {
        return Collections.emptyList();
    }
}

