/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidDeprecationInspection;
import org.jetbrains.android.inspections.VersionChecks;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeprecationFilter
extends AndroidDeprecationInspection.DeprecationFilter {
    private static final String ACTION_BAR_ACTIVITY = "android.support.v7.app.ActionBarActivity";
    private static final String APP_COMPAT_ACTIVITY = "android.support.v7.app.AppCompatActivity";

    private static int getDeprecatedIn(@Nullable Project project, @NotNull PsiElement deprecatedElement) {
        String owner;
        PsiClass containingClass;
        if (project == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        if (apiLookup == null) {
            return -1;
        }
        if (deprecatedElement instanceof PsiClass) {
            String owner2 = LintIdeUtils.getInternalName((PsiClass)deprecatedElement);
            if (owner2 != null) {
                return apiLookup.getClassDeprecatedIn(owner2);
            }
        } else if (deprecatedElement instanceof PsiMember && (containingClass = ((PsiMember)deprecatedElement).getContainingClass()) != null && (owner = LintIdeUtils.getInternalName(containingClass)) != null) {
            if (deprecatedElement instanceof PsiField) {
                String name = ((PsiField)deprecatedElement).getName();
                if (name != null) {
                    return apiLookup.getFieldDeprecatedIn(owner, name);
                }
            } else if (deprecatedElement instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)deprecatedElement;
                String name = LintIdeUtils.getInternalMethodName(method);
                String desc = LintIdeUtils.getInternalDescription(method, false, false);
                if (desc != null) {
                    return apiLookup.getCallDeprecatedIn(owner, name, desc);
                }
            }
        }
        return -1;
    }

    @Override
    public boolean isExcluded(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        AndroidFacet facet;
        Project project = referenceElement.getProject();
        int deprecatedIn = AndroidDeprecationFilter.getDeprecatedIn(project, deprecatedElement);
        if (deprecatedIn != -1 && (facet = AndroidFacet.getInstance(referenceElement)) != null && !facet.isDisposed() && AndroidModuleInfo.getInstance(facet).getMinSdkVersion().getApiLevel() < deprecatedIn) {
            return !VersionChecks.isPrecededByVersionCheckExit(referenceElement, deprecatedIn) && !VersionChecks.isWithinVersionCheckConditional(referenceElement, deprecatedIn);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDeprecationMessage(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName, @NotNull String defaultMessage) {
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            return "ActionBarActivity is deprecated; use `AppCompatActivity` instead";
        }
        int version = AndroidDeprecationFilter.getDeprecatedIn(referenceElement.getProject(), deprecatedElement);
        if (version != -1) {
            return defaultMessage + " as of " + SdkVersionInfo.getAndroidName((int)version);
        }
        return defaultMessage;
    }

    @Override
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            return new LocalQuickFix[]{new ReplaceSuperClassFix(referenceElement, APP_COMPAT_ACTIVITY)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static class ReplaceSuperClassFix
    implements LocalQuickFix {
        private final String myQualifiedName;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myElement;

        public ReplaceSuperClassFix(@NotNull PsiElement element, @NotNull String qualifiedName) {
            this.myQualifiedName = qualifiedName;
            this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace With " + this.myQualifiedName.substring(this.myQualifiedName.lastIndexOf(46) + 1);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace deprecated code";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement replace = this.myElement.getElement();
            if (replace == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = facade.getElementFactory();
            PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(this.myQualifiedName, replace);
            newReference = replace.replace((PsiElement)newReference);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newReference);
        }
    }
}

