/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AddMissingPrefixQuickFix
implements AndroidLintQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AddMissingPrefixQuickFix");

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
        if (attribute == null) {
            return;
        }
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            LOG.debug("tag is null");
            return;
        }
        String androidNsPrefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (androidNsPrefix == null) {
            PsiFile file = tag.getContainingFile();
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)file);
            if (extension == null) {
                LOG.debug("Cannot get XmlNamespaceHelper for file + " + file);
                return;
            }
            if (!(file instanceof XmlFile)) {
                LOG.debug(file + " is not XmlFile");
                return;
            }
            XmlFile xmlFile = (XmlFile)file;
            String defaultPrefix = "android";
            extension.insertNamespaceDeclaration(xmlFile, null, Collections.singleton("http://schemas.android.com/apk/res/android"), "android", null);
            androidNsPrefix = "android";
        }
        attribute.setName(androidNsPrefix + ':' + attribute.getLocalName());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false) != null;
    }

    @Override
    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.add.android.prefix", new Object[0]);
    }
}

