/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.ResourceType;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private static final CharMatcher DISALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate();
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value, file, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String value;
        String defaultName = null;
        PsiElement parent = this.myStartElement.getParent();
        if (parent instanceof XmlAttribute && (value = ((XmlAttribute)parent).getValue()) != null) {
            defaultName = AndroidAddStringResourceQuickFix.buildResourceName(value);
        }
        this.invokeIntention(project, editor, file, defaultName);
    }

    @NotNull
    static String buildResourceName(@NotNull String value) {
        String result = DISALLOWED_CHARS.trimAndCollapseFrom((CharSequence)value, '_').toLowerCase(Locale.US);
        if (!result.isEmpty() && CharMatcher.JAVA_DIGIT.matches(result.charAt(0))) {
            return "_" + result;
        }
        return result;
    }

    public void invokeIntention(Project project, Editor editor, PsiFile file, @Nullable String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor, file, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        return attribute != null ? attribute.getValueElement() : null;
    }
}

