/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeProject;
import com.android.tools.idea.lint.LintIdeRequest;
import com.android.tools.idea.lint.SuppressLintIntentionAction;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFixProvider;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AndroidLintExternalAnnotator
extends ExternalAnnotator<State, State> {
    static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;
    private String myShortcutText;

    @Nullable
    public State collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        return this.collectInformation(file);
    }

    public State collectInformation(@NotNull PsiFile file) {
        Set<Issue> issues;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null && !LintIdeProject.hasAndroidModule(module.getProject())) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            if (facet == null || ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType(file) == null && !"AndroidManifest.xml".equals(vFile.getName())) {
                return null;
            }
        } else if (fileType == FileTypes.PLAIN_TEXT) {
            if (!"proguard-project.txt".equals(file.getName()) && !"proguard.cfg".equals(file.getName())) {
                return null;
            }
        } else if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".gradle")) {
                return null;
            }
            Project project = file.getProject();
            if (AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
                PsiProjectListener.getInstance(project);
            }
        } else if (fileType != StdFileTypes.JAVA && !AndroidLintExternalAnnotator.isKotlin(fileType) && fileType != StdFileTypes.PROPERTIES) {
            return null;
        }
        if ((issues = AndroidLintExternalAnnotator.getIssuesFromInspections(file.getProject(), (PsiElement)file)).isEmpty()) {
            return null;
        }
        return new State(module, vFile, file.getText(), issues);
    }

    public static boolean isKotlin(FileType fileType) {
        return fileType.getName().equals("Kotlin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State doAnnotate(State state) {
        LintIdeClient client = LintIdeClient.forEditor(state);
        try {
            EnumSet scope;
            VirtualFile mainFile = state.getMainFile();
            FileType fileType = mainFile.getFileType();
            String name = mainFile.getName();
            if (fileType == StdFileTypes.XML) {
                scope = name.equals("AndroidManifest.xml") ? Scope.MANIFEST_SCOPE : Scope.RESOURCE_FILE_SCOPE;
            } else if (fileType == StdFileTypes.JAVA || AndroidLintExternalAnnotator.isKotlin(fileType)) {
                scope = Scope.JAVA_FILE_SCOPE;
            } else if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                scope = EnumSet.of(Scope.PROGUARD_FILE);
            } else if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType == StdFileTypes.PROPERTIES) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                assert (false);
                State state2 = state;
                return state2;
            }
            Project project = state.getModule().getProject();
            if (project.isDisposed()) {
                State state3 = state;
                return state3;
            }
            if (DumbService.isDumb((Project)project)) {
                State state4 = state;
                return state4;
            }
            List<VirtualFile> files = Collections.singletonList(mainFile);
            LintIdeRequest request = new LintIdeRequest(client, project, files, Collections.singletonList(state.getModule()), true);
            request.setScope(scope);
            LintDriver lint = new LintDriver((IssueRegistry)new LintIdeIssueRegistry(), (LintClient)client, (LintRequest)request);
            lint.analyze();
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
        return state;
    }

    @NotNull
    static Set<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
        LintIdeIssueRegistry fullRegistry = new LintIdeIssueRegistry();
        List issueList = fullRegistry.getIssues();
        HashSet result = Sets.newHashSetWithExpectedSize((int)(issueList.size() + 10));
        for (Issue issue2 : issueList) {
            HighlightDisplayKey key;
            String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue2);
            if (inspectionShortName == null || (key = HighlightDisplayKey.find((String)inspectionShortName)) == null) continue;
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
            if (!enabled) continue;
            if (!issue2.isEnabledByDefault()) {
                issue2.setEnabledByDefault(true);
            }
            result.add(issue2);
        }
        return result;
    }

    public void apply(@NotNull PsiFile file, State state, @NotNull AnnotationHolder holder) {
        if (state.isDirty()) {
            return;
        }
        Project project = file.getProject();
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        AndroidLintQuickFixProvider[] fixProviders = (AndroidLintQuickFixProvider[])AndroidLintQuickFixProvider.EP_NAME.getExtensions();
        for (ProblemData problemData : state.getProblems()) {
            AndroidLintQuickFix[] fixes;
            HighlightDisplayLevel configuredLevel;
            HighlightDisplayKey key;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue2 = problemData.getIssue();
            String message = problemData.getMessage();
            TextRange range = problemData.getTextRange();
            LintFix quickfixData = problemData.getQuickfixData();
            if (range.getStartOffset() == range.getEndOffset() || (pair = AndroidLintUtil.getHighlightLevelAndInspection(project, issue2, (PsiElement)file)) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.getFirst());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.getSecond();
            if (inspection == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            if (problemData.getConfiguredSeverity() != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(problemData.getConfiguredSeverity())) != null) {
                displayLevel = configuredLevel;
            }
            Annotation annotation = this.createAnnotation(holder, message, range, displayLevel, issue2);
            for (AndroidLintQuickFix androidLintQuickFix : fixes = inspection.getAllFixes(startElement, endElement, message, quickfixData, fixProviders, issue2)) {
                if (!androidLintQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                annotation.registerFix((IntentionAction)new MyFixingIntention(androidLintQuickFix, startElement, endElement));
            }
            for (AndroidLintQuickFix androidLintQuickFix : inspection.getIntentions(startElement, endElement)) {
                annotation.registerFix((IntentionAction)androidLintQuickFix);
            }
            String id = key.getID();
            annotation.registerFix((IntentionAction)new SuppressLintIntentionAction(id, startElement));
            if (issue2 != DeprecationDetector.ISSUE && issue2 != GradleDetector.DEPRECATED) continue;
            annotation.setHighlightType(ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    @NotNull
    private Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull String message, @NotNull TextRange range, @NotNull HighlightDisplayLevel displayLevel, @NotNull Issue issue2) {
        HighlightSeverity severity = displayLevel == HighlightDisplayLevel.ERROR ? HighlightSeverity.ERROR : (displayLevel == HighlightDisplayLevel.WARNING ? HighlightSeverity.WARNING : (displayLevel == HighlightDisplayLevel.WEAK_WARNING ? HighlightSeverity.WEAK_WARNING : (displayLevel == HighlightDisplayLevel.INFO ? HighlightSeverity.INFO : HighlightSeverity.WARNING)));
        String link = " <a href=\"#lint/" + issue2.getId() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.getShowMoreShortCut();
        String tooltip = XmlStringUtil.wrapInHtml((CharSequence)(TextFormat.RAW.convertTo(message, TextFormat.HTML) + link));
        return holder.createAnnotation(severity, range, message, tooltip);
    }

    private String getShowMoreShortCut() {
        if (this.myShortcutText == null) {
            Keymap keymap;
            KeymapManager keymapManager = KeymapManager.getInstance();
            this.myShortcutText = keymapManager != null ? ((keymap = keymapManager.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        }
        return this.myShortcutText;
    }

    private static class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        private MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, @NotNull AndroidLintInspectionBase inspection) {
            super(key, () -> "Edit '" + inspection.getDisplayName() + "' inspection settings");
        }
    }

    public static class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final AndroidLintQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        public MyFixingIntention(@NotNull AndroidLintQuickFix quickFix, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.myQuickFix = quickFix;
            this.myStartElement = startElement;
            this.myEndElement = endElement;
        }

        @NotNull
        public String getText() {
            return this.myQuickFix.getName();
        }

        @NotNull
        public String getFamilyName() {
            return AndroidBundle.message("android.lint.quickfixes.family", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            return this.myDisableInspectionToolAction.getElementToMakeWritable(file);
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myDisableInspectionToolAction.getIcon(flags);
        }
    }
}

