/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.Density;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ConvertToDpQuickFix
implements AndroidLintQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.ConvertToDpQuickFix");
    private static final Pattern PX_ATTR_VALUE_PATTERN = Pattern.compile("(\\d+)px");
    private static int ourPrevDpi = 160;

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        String newValue;
        int dpi;
        if (context instanceof AndroidQuickfixContexts.BatchContext) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        ArrayList<Density> densities = new ArrayList<Density>();
        for (Density density : Density.values()) {
            if (density.getDpiValue() <= 0) continue;
            densities.add(density);
        }
        String[] densityPresentableNames = new String[densities.size()];
        String defaultValue = null;
        String initialValue = null;
        for (int i = 0; i < densities.size(); ++i) {
            Density density = (Density)densities.get(i);
            densityPresentableNames[i] = ConvertToDpQuickFix.getLabelForDensity(density);
            int dpi2 = density.getDpiValue();
            if (dpi2 == 0) continue;
            if (dpi2 == ourPrevDpi) {
                initialValue = densityPresentableNames[i];
                continue;
            }
            if (dpi2 != 160) continue;
            defaultValue = densityPresentableNames[i];
        }
        if (initialValue == null) {
            initialValue = defaultValue;
        }
        if (initialValue == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dpi = 160;
        } else {
            int selectedIndex = Messages.showChooseDialog((String)"What is the screen density the current px value works with?", (String)"Choose density", (String[])densityPresentableNames, initialValue, null);
            if (selectedIndex < 0) {
                return;
            }
            dpi = ((Density)densities.get(selectedIndex)).getDpiValue();
        }
        ourPrevDpi = dpi;
        for (XmlAttribute attribute : tag.getAttributes()) {
            String newValue2;
            String value = attribute.getValue();
            if (value == null || !value.endsWith("px") || (newValue2 = ConvertToDpQuickFix.convertToDp(value, dpi)) == null) continue;
            attribute.setValue(newValue2);
        }
        XmlTagValue tagValueElement = tag.getValue();
        String tagValue = tagValueElement.getText();
        if (tagValue.endsWith("px") && (newValue = ConvertToDpQuickFix.convertToDp(tagValue, dpi)) != null) {
            tagValueElement.setText(newValue);
        }
    }

    private static String convertToDp(String value, int dpi) {
        String newValue = null;
        Matcher matcher = PX_ATTR_VALUE_PATTERN.matcher(value);
        if (matcher.matches()) {
            String numberString = matcher.group(1);
            try {
                int px = Integer.parseInt(numberString);
                int dp = px * 160 / dpi;
                newValue = Integer.toString(dp) + "dp";
            }
            catch (NumberFormatException nufe) {
                LOG.error((Throwable)nufe);
            }
        }
        return newValue;
    }

    @NotNull
    private static String getLabelForDensity(@NotNull Density density) {
        return String.format("%1$s (%2$d)", density.getShortDisplayValue(), density.getDpiValue());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return contextType != AndroidQuickfixContexts.BatchContext.TYPE && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.convert.to.dp", new Object[0]);
    }
}

