/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAttributeQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    private final String myAttributeName;
    private final String myValue;
    private final String myNamespace;
    private final int myDot;
    private final int myMark;

    public SetAttributeQuickFix(@NotNull String name, @NotNull String attributeName, @Nullable String value) {
        this(name, attributeName, "http://schemas.android.com/apk/res/android", value);
    }

    public SetAttributeQuickFix(@NotNull String name, @NotNull String attributeName, @Nullable String namespace, @Nullable String value) {
        this(name, attributeName, namespace, value, value != null ? 0 : Integer.MIN_VALUE, value != null ? value.length() : Integer.MIN_VALUE);
    }

    public SetAttributeQuickFix(@NotNull String name, @NotNull String attributeName, @Nullable String namespace, @Nullable String value, int dot, int mark) {
        this.myName = name;
        this.myAttributeName = attributeName;
        this.myValue = value;
        this.myNamespace = namespace;
        this.myDot = dot;
        this.myMark = mark;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        XmlFile file;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        String value = this.myValue;
        if (value == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value = this.askForAttributeValue((PsiElement)tag)) == null) {
            return;
        }
        if (this.myNamespace != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class)) != null) {
            AndroidResourceUtil.ensureNamespaceImported(file, this.myNamespace, null);
        }
        XmlAttribute xmlAttribute = attribute = this.myNamespace != null ? tag.setAttribute(this.myAttributeName, this.myNamespace, "") : tag.setAttribute(this.myAttributeName, "");
        if (attribute != null) {
            if (value != null && !value.isEmpty()) {
                attribute.setValue(value);
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    if (this.myDot != Integer.MIN_VALUE) {
                        int end = valueElementStart + valueTextRange.getStartOffset() + this.myDot;
                        if (this.myMark != Integer.MIN_VALUE && this.myMark != this.myDot) {
                            int start = valueElementStart + valueTextRange.getStartOffset() + this.myMark;
                            editor.getCaretModel().moveToOffset(end);
                            editor.getSelectionModel().setSelection(start, end);
                        } else {
                            editor.getCaretModel().moveToOffset(end);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    private String askForAttributeValue(@NotNull PsiElement context) {
        String[] variants;
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        SystemResourceManager srm;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        String message = "Specify value of attribute '" + this.myAttributeName + "'";
        String title = "Set Attribute Value";
        if (facet != null && (srm = ModuleResourceManagers.getInstance(facet).getSystemResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(this.myAttributeName)) != null && (variants = def.getValues()).length > 0) {
            return Messages.showEditableChooseDialog((String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
        }
        return Messages.showInputDialog((Project)context.getProject(), (String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        XmlAttribute attribute = this.myNamespace != null ? tag.getAttribute(this.myAttributeName, this.myNamespace) : tag.getAttribute(this.myAttributeName);
        return attribute == null || !StringUtil.notNullize((String)this.myValue).equals(StringUtil.notNullize((String)attribute.getValue()));
    }
}

