/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.tools.idea.lint.ParcelableQuickFix;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementParcelableAction
extends AbstractIntentionAction
implements HighPriorityAction {
    private final ParcelableQuickFix myQuickFix;

    public ImplementParcelableAction() {
        this(ParcelableQuickFix.Operation.IMPLEMENT);
    }

    protected ImplementParcelableAction(ParcelableQuickFix.Operation operation) {
        this.myQuickFix = new ParcelableQuickFix(this.getText(), operation);
    }

    @Nls
    @NotNull
    public String getText() {
        return AndroidBundle.message("implement.parcelable.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element = ImplementParcelableAction.getPsiElement(file, editor);
        return element != null && this.myQuickFix.isApplicable(element, element, AndroidQuickfixContexts.DesignerContext.TYPE);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element = ImplementParcelableAction.getPsiElement(file, editor);
        this.myQuickFix.apply(element, element, AndroidQuickfixContexts.DesignerContext.getInstance());
    }

    @Nullable
    private static PsiElement getPsiElement(PsiFile file, Editor editor) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? element.getParent() : null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

