/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeRequest;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.refactoring.UnusedResourcesUsageViewDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

public class UnusedResourcesProcessor
extends BaseRefactoringProcessor {
    private final String myFilter;
    private final Module[] myModules;
    private PsiElement[] myElements = PsiElement.EMPTY_ARRAY;
    private boolean myIncludeIds;
    private String myCachedCommandName = null;

    public UnusedResourcesProcessor(@NotNull Project project, @NotNull Module[] modules, @Nullable String filter) {
        super(project, null);
        this.myModules = modules;
        this.myFilter = filter;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UnusedResourcesUsageViewDescriptor(this.myElements);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Map<Issue, Map<File, List<ProblemData>>> map = this.computeUnusedMap();
        List<PsiElement> elements = this.computeUnusedDeclarationElements(map);
        this.myElements = elements.toArray(new PsiElement[elements.size()]);
        UsageInfo[] result = new UsageInfo[this.myElements.length];
        for (PsiElement element : this.myElements) {
            if (element instanceof PsiBinaryFile) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
                SmartPsiElementPointer smartPointer = smartPointerManager.createSmartPsiElementPointer(element);
                SmartPsiFileRange smartFileRange = smartPointerManager.createSmartPsiFileRangePointer((PsiFile)((PsiBinaryFile)element), TextRange.EMPTY_RANGE);
                result[i] = new UsageInfo(smartPointer, smartFileRange, false, false){

                    public boolean isValid() {
                        return true;
                    }

                    @Nullable
                    public Segment getSegment() {
                        return null;
                    }
                };
                continue;
            }
            result[i] = new UsageInfo(element);
        }
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result);
    }

    @NotNull
    private List<PsiElement> computeUnusedDeclarationElements(Map<Issue, Map<File, List<ProblemData>>> map) {
        final ArrayList elements = Lists.newArrayList();
        for (Issue issue2 : Lists.newArrayList(map.keySet())) {
            if (issue2 == UnusedResourceDetector.ISSUE || issue2 == UnusedResourceDetector.ISSUE_IDS) continue;
            map.remove(issue2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (Issue issue3 : new Issue[]{UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS}) {
            final Map<File, List<ProblemData>> fileListMap = map.get(issue3);
            if (fileListMap == null || fileListMap.isEmpty()) continue;
            HashMap files = Maps.newHashMap();
            for (File file : fileListMap.keySet()) {
                PsiFile psiFile;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile == null || virtualFile.isDirectory() || (psiFile = manager.findFile(virtualFile)) == null) continue;
                files.put(file, psiFile);
            }
            if (files.isEmpty()) continue;
            for (File file : files.keySet()) {
                final PsiFile psiFile = (PsiFile)files.get(file);
                if (psiFile == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)psiFile)) continue;
                List<ProblemData> problems = fileListMap.get(file);
                if (psiFile.getFileType().isBinary()) {
                    if (!this.matchesFilter(fileListMap, file)) continue;
                    elements.add(psiFile);
                    continue;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType == null) {
                    if (psiFile.getFileType() != GroovyFileType.GROOVY_FILE_TYPE || !(psiFile instanceof GroovyFile)) continue;
                    ((GroovyFile)psiFile).accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                        public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
                            GrExpression[] args;
                            super.visitApplicationStatement(applicationStatement);
                            PsiMethod method = applicationStatement.resolveMethod();
                            if (method != null && method.getName().equals("resValue") && (args = applicationStatement.getArgumentList().getExpressionArguments()).length >= 3) {
                                List problems;
                                Object typeString = GroovyConstantExpressionEvaluator.evaluate((GrExpression)args[0]);
                                Object nameString = GroovyConstantExpressionEvaluator.evaluate((GrExpression)args[1]);
                                if (typeString != null && nameString != null && (problems = (List)fileListMap.get(VfsUtilCore.virtualToIoFile((VirtualFile)psiFile.getVirtualFile()))) != null) {
                                    for (ProblemData problem : problems) {
                                        String unusedResource = (String)LintFix.getData((LintFix)problem.getQuickfixData(), String.class);
                                        if (unusedResource == null || !unusedResource.equals("R." + typeString + '.' + nameString)) continue;
                                        elements.add(applicationStatement);
                                    }
                                }
                            }
                        }
                    });
                    continue;
                }
                if (folderType != ResourceFolderType.VALUES) {
                    if (issue3 == UnusedResourceDetector.ISSUE_IDS) {
                        Map<File, List<ProblemData>> m = map.get(UnusedResourceDetector.ISSUE);
                        if (m != null && m.containsKey(file)) continue;
                        this.addElementsInFile(elements, psiFile, problems);
                        continue;
                    }
                    if (!this.matchesFilter(fileListMap, file)) continue;
                    elements.add(psiFile);
                    continue;
                }
                this.addElementsInFile(elements, psiFile, problems);
            }
        }
        return elements;
    }

    private void addElementsInFile(List<PsiElement> elements, PsiFile psiFile, List<ProblemData> problems) {
        if (psiFile instanceof XmlFile) {
            ArrayList starts = Lists.newArrayListWithCapacity((int)problems.size());
            for (ProblemData problem : problems) {
                if (!this.matchesFilter(problem)) continue;
                starts.add(problem.getTextRange().getStartOffset());
            }
            starts.sort(Collections.reverseOrder());
            for (Integer offset : starts) {
                XmlAttribute attribute;
                if (!psiFile.isValid()) continue;
                XmlAttribute remove = attribute = (XmlAttribute)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlAttribute.class, (boolean)false);
                if (attribute == null) {
                    remove = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlTag.class, (boolean)false);
                } else if (!"id".equals(attribute.getLocalName())) {
                    remove = PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
                }
                if (remove == null) continue;
                elements.add((PsiElement)remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Issue, Map<File, List<ProblemData>>> computeUnusedMap() {
        HashMap map = Maps.newHashMap();
        ImmutableSet issues = this.myIncludeIds ? ImmutableSet.of((Object)UnusedResourceDetector.ISSUE, (Object)UnusedResourceDetector.ISSUE_IDS) : ImmutableSet.of((Object)UnusedResourceDetector.ISSUE);
        AnalysisScope scope = new AnalysisScope(this.myProject);
        boolean unusedWasEnabled = UnusedResourceDetector.ISSUE.isEnabledByDefault();
        boolean unusedIdsWasEnabled = UnusedResourceDetector.ISSUE_IDS.isEnabledByDefault();
        UnusedResourceDetector.ISSUE.setEnabledByDefault(true);
        UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(this.myIncludeIds);
        try {
            LintIdeClient client = LintIdeClient.forBatch(this.myProject, map, scope, (Set<Issue>)issues);
            LintIdeRequest request = new LintIdeRequest(client, this.myProject, null, Arrays.asList(this.myModules), false);
            request.setScope(Scope.ALL);
            LintDriver lint = new LintDriver((IssueRegistry)new LintIdeIssueRegistry(), (LintClient)client, (LintRequest)request);
            lint.analyze();
        }
        finally {
            UnusedResourceDetector.ISSUE.setEnabledByDefault(unusedWasEnabled);
            UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(unusedIdsWasEnabled);
        }
        return map;
    }

    private boolean matchesFilter(@NotNull Map<File, List<ProblemData>> fileListMap, @NotNull File file) {
        if (this.myFilter != null) {
            List<ProblemData> problems = fileListMap.get(file);
            for (ProblemData problem : problems) {
                String unusedResource = (String)LintFix.getData((LintFix)problem.getQuickfixData(), String.class);
                if (!this.myFilter.equals(unusedResource)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesFilter(@NotNull ProblemData problem) {
        return this.myFilter == null || this.myFilter.equals(LintFix.getData((LintFix)problem.getQuickfixData(), String.class));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        return true;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        return beforeData;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.unused.resources";
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        try {
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null || !element.isValid()) continue;
                element.delete();
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    private String calcCommandName() {
        return "Deleting " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElements);
    }

    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        return this.myCachedCommandName;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    public void setIncludeIds(boolean includeIds) {
        this.myIncludeIds = includeIds;
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        PsiElement element;
        if (ApplicationManager.getApplication().isUnitTestMode() && (element = usageInfo.getElement()) != null && element.getText().contains("AUTO-EXCLUDE")) {
            return false;
        }
        return super.isToBeChanged(usageInfo);
    }
}

