/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredAttributeDefinitions
implements AttributeDefinitions {
    private final AttributeDefinitions myWrappee;

    protected FilteredAttributeDefinitions(@NotNull AttributeDefinitions wrappee) {
        this.myWrappee = wrappee;
    }

    protected abstract boolean isAttributeAcceptable(@NotNull String var1);

    @Override
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name) {
        StyleableDefinition styleable = this.myWrappee.getStyleableByName(name);
        return styleable != null ? new MyStyleableDefinition(styleable) : null;
    }

    @Override
    @NotNull
    public Set<String> getAttributeNames() {
        HashSet result = new HashSet();
        for (String name : this.myWrappee.getAttributeNames()) {
            if (!this.isAttributeAcceptable(name)) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        return this.isAttributeAcceptable(name) ? this.myWrappee.getAttrDefByName(name) : null;
    }

    @Override
    @Nullable
    public String getAttrGroupByName(@NotNull String name) {
        return this.myWrappee.getAttrGroupByName(name);
    }

    private class MyStyleableDefinition
    implements StyleableDefinition {
        private final StyleableDefinition myWrappee;

        private MyStyleableDefinition(StyleableDefinition wrappee) {
            this.myWrappee = wrappee;
        }

        @Override
        @NotNull
        public List<StyleableDefinition> getChildren() {
            List<StyleableDefinition> styleables = this.myWrappee.getChildren();
            ArrayList<StyleableDefinition> result = new ArrayList<StyleableDefinition>(styleables.size());
            for (StyleableDefinition styleable : styleables) {
                result.add(new MyStyleableDefinition(styleable));
            }
            return result;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myWrappee.getName();
        }

        @Override
        @NotNull
        public List<AttributeDefinition> getAttributes() {
            ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
            for (AttributeDefinition definition : this.myWrappee.getAttributes()) {
                if (!FilteredAttributeDefinitions.this.isAttributeAcceptable(definition.getName())) continue;
                result.add(definition);
            }
            return result;
        }
    }
}

