/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResourceManagers
extends AndroidFacetScopedService {
    @VisibleForTesting
    public static final Key<ModuleResourceManagers> KEY = Key.create((String)ModuleResourceManagers.class.getName());
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;

    @NotNull
    public static ModuleResourceManagers getInstance(@NotNull AndroidFacet facet) {
        ModuleResourceManagers resourceManagers = (ModuleResourceManagers)facet.getUserData(KEY);
        if (resourceManagers == null) {
            resourceManagers = new ModuleResourceManagers(facet);
            facet.putUserData(KEY, resourceManagers);
        }
        return resourceManagers;
    }

    private ModuleResourceManagers(@NotNull AndroidFacet facet) {
        super(facet);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidSdks.getInstance().isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this.getFacet());
        }
        return this.myLocalResourceManager;
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    public void clear() {
        this.myLocalResourceManager = null;
        this.myPublicSystemResourceManager = null;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

