/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract Multimap<String, VirtualFile> getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor) {
        return this.processFileResources(folderType, processor, true);
    }

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor, boolean withDependencies) {
        return this.processFileResources(folderType, processor, withDependencies, true);
    }

    public boolean processFileResources(@NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor, boolean withDependencies, boolean publicOnly) {
        Multimap<String, VirtualFile> resDirs;
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            resDirs = HashMultimap.create();
            resDirs.putAll(null, this.getResourceDirs());
        }
        for (Map.Entry entry : resDirs.asMap().entrySet()) {
            for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, (Collection)entry.getValue())) {
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
                if (resType == null) continue;
                assert (folderType.equals((Object)resType));
                String resTypeName = resType.getName();
                for (VirtualFile resFile : resSubdir.getChildren()) {
                    String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                    if (resFile.isDirectory() || publicOnly && !this.isResourcePublic(resTypeName, resName) || processor.process(resFile, resName, (String)entry.getKey())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        return true;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType) {
        return AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs().values());
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType, @Nullable String resName, boolean distinguishDelimetersInName, String ... extensions) {
        return this.findResourceFiles(resourceType, resName, distinguishDelimetersInName, true, extensions);
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceFolderType, @Nullable String resName1, boolean distinguishDelimitersInName, boolean withDependencies, String ... extensions) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        HashSet extensionSet = new HashSet();
        Collections.addAll(extensionSet, extensions);
        this.processFileResources(resourceFolderType, (arg_0, arg_1, arg_2) -> this.lambda$findResourceFiles$0(extensions, (Set)extensionSet, resName1, distinguishDelimitersInName, result, arg_0, arg_1, arg_2), withDependencies);
        return result;
    }

    @NotNull
    public <T> Multimap<String, T> findResourceFilesByLibraryName(@NotNull ResourceFolderType folderType, @NotNull Class<T> fileClass) {
        HashMultimap result = HashMultimap.create();
        this.processFileResources(folderType, (arg_0, arg_1, arg_2) -> this.lambda$findResourceFilesByLibraryName$1(fileClass, (Multimap)result, arg_0, arg_1, arg_2), true);
        return result;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType) {
        return this.findResourceFiles(resourceType, null, true, new String[0]);
    }

    protected List<Pair<Resources, VirtualFile>> getResourceElements(@Nullable Set<VirtualFile> files) {
        return this.getRootDomElements(Resources.class, files);
    }

    private <T extends DomElement> List<Pair<T, VirtualFile>> getRootDomElements(@NotNull Class<T> elementType, @Nullable Set<VirtualFile> files) {
        ArrayList<Pair<T, VirtualFile>> result = new ArrayList<Pair<T, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            T element;
            if (files != null && !files.contains(file) || !file.isValid() || (element = AndroidUtils.loadDomElement(this.myProject, file, elementType)) == null) continue;
            result.add(Pair.create(element, (Object)file));
        }
        return result;
    }

    @NotNull
    protected Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs(ResourceFolderType.VALUES)) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        return files;
    }

    protected List<ResourceElement> getValueResources(@NotNull ResourceType resourceType, @Nullable Set<VirtualFile> files) {
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements(files);
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!resources.isValid() || this.myProject.isDisposed()) {
                    return;
                }
                List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                for (ResourceElement valueResource : valueResources) {
                    String resName = (String)valueResource.getName().getValue();
                    if (resName == null || !this.isResourcePublic(resourceType.getName(), resName)) continue;
                    result.add(valueResource);
                }
            });
        }
        return result;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType = this.getFileResourceFolderType(tag.getContainingFile());
        if (ResourceFolderType.VALUES == fileResType) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(final @NotNull PsiFile file) {
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

            @Nullable
            public ResourceFolderType compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                return ResourceFolderType.getFolderType((String)dir.getName());
            }
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType = this.getFileResourceFolderType(file);
        return folderType == null ? null : folderType.getName();
    }

    @NotNull
    private Set<String> getFileResourcesNames(@NotNull ResourceFolderType resourceType) {
        HashSet result = new HashSet();
        this.processFileResources(resourceType, (arg_0, arg_1, arg_2) -> ResourceManager.lambda$getFileResourcesNames$3((Set)result, arg_0, arg_1, arg_2));
        return result;
    }

    @NotNull
    public Collection<String> getValueResourceNames(@NotNull ResourceType resourceType) {
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR == resourceType;
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        return result;
    }

    @NotNull
    public Collection<ResourceEntry> getValueResourceEntries(@NotNull ResourceType resourceType) {
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (arg_0, arg_1) -> ResourceManager.lambda$getValueResourceEntries$4((Map)file2resourceSet, arg_0, arg_1), scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType type) {
        return this.getResourceNames(type, false);
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(resourceType));
        List folders = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
        if (!folders.isEmpty()) {
            for (ResourceFolderType folderType : folders) {
                if (folderType == ResourceFolderType.VALUES) continue;
                result.addAll(this.getFileResourcesNames(folderType));
            }
        }
        if (resourceType == ResourceType.ID) {
            result.addAll(this.getIds(true));
        }
        return result;
    }

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(final @NotNull String id) {
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            return Collections.emptyList();
        }
        final ArrayList<XmlAttributeValue> declarations = new ArrayList<XmlAttributeValue>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        HashSet fileSet = new HashSet(files);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        String idInAttr;
                        if (AndroidResourceUtil.isIdDeclaration(attributeValue) && id.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                            declarations.add(attributeValue);
                        }
                    }
                });
            }
        }
        return declarations;
    }

    @NotNull
    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (arg_0, arg_1) -> ResourceManager.lambda$getIds$5((Map)file2idEntries, arg_0, arg_1), scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        return result;
    }

    @NotNull
    public List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceFolderType type : FolderTypeRelationship.getIdGeneratingFolderTypes()) {
            resSubdirs.addAll(this.getResourceSubdirs(type));
        }
        return resSubdirs;
    }

    public List<ResourceElement> findValueResources(@NotNull String resType, @NotNull String resName) {
        return this.findValueResources(resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        return result;
    }

    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        ResourceFolderType folderType;
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.isEmpty() && (folderType = ResourceFolderType.getTypeByName((String)resType)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, resName, false, new String[0])) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (file, infos) -> {
            for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                String name = info.getResourceEntry().getName();
                if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, this.myProject, info.getOffset()));
            }
            return true;
        }, scope);
        return result;
    }

    private static /* synthetic */ boolean lambda$getIds$5(Map file2idEntries, VirtualFile file, Set value) {
        file2idEntries.put(file, value);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValueResourceEntries$4(Map file2resourceSet, VirtualFile file, ImmutableSet infos) {
        for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
            Set resourcesInFile = (Set)file2resourceSet.get(file);
            if (resourcesInFile == null) {
                resourcesInFile = new HashSet();
                file2resourceSet.put(file, resourcesInFile);
            }
            resourcesInFile.add(info.getResourceEntry());
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getFileResourcesNames$3(Set result, VirtualFile resFile, String resName, String libraryName) {
        result.add(resName);
        return true;
    }

    private /* synthetic */ boolean lambda$findResourceFilesByLibraryName$1(@NotNull Class fileClass, Multimap result, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile);
        if (file != null && fileClass.isInstance(file)) {
            result.put((Object)libraryName, fileClass.cast(file));
        }
        return true;
    }

    private /* synthetic */ boolean lambda$findResourceFiles$0(@NotNull String[] extensions, Set extensionSet, @Nullable String resName1, boolean distinguishDelimitersInName, List result, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file;
        String extension = resFile.getExtension();
        if ((extensions.length == 0 || extensionSet.contains(extension)) && (resName1 == null || AndroidUtils.equal(resName1, resName, distinguishDelimitersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null) {
            result.add(file);
        }
        return true;
    }
}

