/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemResourceManager
extends ResourceManager {
    private final AndroidPlatform myPlatform;
    private final boolean myPublicOnly;

    public SystemResourceManager(@NotNull Project project, @NotNull AndroidPlatform androidPlatform, boolean publicOnly) {
        super(project);
        this.myPlatform = androidPlatform;
        this.myPublicOnly = publicOnly;
    }

    @Override
    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        return !this.myPublicOnly || this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).isResourcePublic(type, name);
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        VirtualFile resDir = this.getResourceDir();
        HashMultimap result = HashMultimap.create();
        if (resDir != null) {
            result.put(null, (Object)resDir);
        }
        return result;
    }

    @Nullable
    private VirtualFile getResourceDir() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        return dir.equals(this.getResourceDir());
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(resPath);
        return dir != null ? Collections.singletonList(dir) : Collections.emptyList();
    }

    @Nullable
    public static SystemResourceManager getInstance(@NotNull ConvertContext context) {
        AndroidFacet facet = AndroidFacet.getInstance(context);
        return facet != null ? ModuleResourceManagers.getInstance(facet).getSystemResourceManager() : null;
    }

    @Override
    @Nullable
    public synchronized AttributeDefinitions getAttributeDefinitions() {
        return this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).getPublicAttrDefs(this.myProject);
    }
}

