/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private final LayoutLibrary myLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");
    private static WeakHashMap<Module, ModuleClassLoader> ourCache = new WeakHashMap();

    private ModuleClassLoader(@NotNull LayoutLibrary library, @NotNull Module module) {
        super(library.getClassLoader(), library.getApiLevel());
        this.myLibrary = library;
        this.myModuleReference = new WeakReference<Module>(module);
        ModuleClassLoader.getLibraryJarFiles(ModuleClassLoader.getExternalLibraries(module)).forEach(jarFile -> ModuleClassLoader.registerLibraryResourceFiles(module, jarFile));
    }

    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findClass(%s)", name));
        }
        try {
            Module module;
            if (!this.myInsideJarClassLoader && (module = (Module)this.myModuleReference.get()) != null && ModuleClassLoader.isResourceClassName(name)) {
                AppResourceRepository appResources = AppResourceRepository.findExistingInstance(module);
                if (appResources != null) {
                    byte[] data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, appResources);
                    if (data != null) {
                        data = this.convertClass(data);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("  Defining class from AAR registry");
                        }
                        return this.defineClassAndPackage(name, data, 0, data.length);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("  AppResourceRepositoryInstance not found");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  super.findClass(%s)", LogAnonymizerUtil.anonymizeClassName(name)));
            }
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] clazz = null;
            if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                clazz = RecyclerViewHelper.getAdapterClass();
            }
            if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                clazz = RecyclerViewHelper.getViewHolder();
            }
            if (clazz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Defining RecyclerView helper class");
                }
                return this.defineClassAndPackage(name, clazz, 0, clazz.length);
            }
            LOG.debug((Throwable)e);
            throw e;
        }
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Module module;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName(name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name, new HashSet<Module>());
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            return aClass;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("  ClassNotFoundException(%s)", LogAnonymizerUtil.anonymizeClassName(name)));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean loadFromProject = name.startsWith("android.support.constraint.solver");
        if (loadFromProject) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                return this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        Class<?> aClass;
        if (!visited.add(module)) {
            return null;
        }
        if (module.isDisposed()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModuleOrDependency(%s, %s)", LogAnonymizerUtil.anonymize(module), LogAnonymizerUtil.anonymizeClassName(name)));
        }
        if ((aClass = this.loadClassFromModule(module, name)) != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        AndroidModel androidModel;
        AndroidFacet facet;
        if (module.isDisposed()) {
            return null;
        }
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassFromModule(%s, %s)", LogAnonymizerUtil.anonymize(module), LogAnonymizerUtil.anonymizeClassName(name)));
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        VirtualFile classFile = null;
        if (vOutFolder != null) {
            classFile = ClassJarProvider.findClassFileInPath(vOutFolder, name);
        }
        if (classFile == null && (facet = AndroidFacet.getInstance(module)) != null && facet.requiresAndroidModel() && (androidModel = facet.getAndroidModel()) != null) {
            classFile = androidModel.getClassJarProvider().findModuleClassFile(name, module);
        }
        if (classFile != null) {
            return this.loadClassFile(name, classFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Class not found");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String fqcn, @Nullable Object myCredential) {
        if (ModuleClassLoader.isResourceClassName(fqcn)) {
            return false;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(fqcn);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = facet.getAndroidModel().isClassFileOutOfDate(module, fqcn, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className) {
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (this.myClassFiles == null) {
            this.myClassFiles = Maps.newHashMap();
            this.myClassFilesLastModified = Maps.newHashMap();
        }
        this.myClassFiles.put(fqcn, classFile);
        this.myClassFilesLastModified.put(fqcn, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(fqcn, classFile);
    }

    @NotNull
    private static Stream<File> getExternalLibraries(Module module) {
        AndroidModel model;
        if (module == null) {
            return Stream.empty();
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && facet.requiresAndroidModel() && (model = facet.getAndroidModel()) != null) {
            return model.getClassJarProvider().getModuleExternalLibraries(module).stream();
        }
        return AndroidRootUtil.getExternalLibraries(module).stream().map(VfsUtilCore::virtualToIoFile);
    }

    private static void registerLibraryResourceFiles(@NotNull Module module, @NotNull File jarFile) {
        FileResourceRepository repository;
        AppResourceRepository appResources;
        File manifest;
        File aarDir = jarFile.getParentFile();
        if (aarDir.getPath().endsWith(".aar") || aarDir.getPath().contains("exploded-aar")) {
            AppResourceRepository appResources2;
            if (aarDir.getPath().contains("exploded-aar")) {
                if (aarDir.getPath().endsWith("libs")) {
                    aarDir = aarDir.getParentFile();
                }
                if (aarDir.getPath().endsWith("jars")) {
                    aarDir = aarDir.getParentFile();
                }
            }
            if ((appResources2 = AppResourceRepository.getOrCreateInstance(module)) != null) {
                ResourceClassRegistry.get(module.getProject()).addAarLibrary(appResources2, aarDir);
            }
            return;
        }
        File parentFile = aarDir.getParentFile();
        if (parentFile != null && (manifest = new File(parentFile, "AndroidManifest.xml")).exists() && (appResources = AppResourceRepository.getOrCreateInstance(module)) != null && (repository = appResources.findRepositoryFor(parentFile)) != null) {
            ResourceClassRegistry registry = ResourceClassRegistry.get(module.getProject());
            registry.addLibrary(appResources, registry.getAarPackage(parentFile));
        }
    }

    @NotNull
    private static Stream<File> getLibraryJarFiles(@NotNull Stream<File> externalLibraries) {
        return externalLibraries.filter(vFile -> "jar".equals(Files.getFileExtension((String)vFile.getName()))).filter(File::exists);
    }

    @Override
    protected List<URL> getExternalJars() {
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        URL customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl();
        if (customWidgetsUrl != null) {
            result.add(customWidgetsUrl);
        }
        ModuleClassLoader.getLibraryJarFiles(ModuleClassLoader.getExternalLibraries(module)).peek(jarFile -> {
            try {
                result.add(SdkUtils.fileToUrl((File)jarFile));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }).forEach(jarFile -> ModuleClassLoader.registerLibraryResourceFiles(module, jarFile));
        return result;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        ModuleClassLoader loader;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ModuleClassLoader.get(%s)", LogAnonymizerUtil.anonymize(module)));
        }
        if ((loader = ourCache.get(module)) != null) {
            if (library != loader.myLibrary) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because the layout library has changed");
                }
                loader = null;
            } else if (!loader.isUpToDate()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because some files have changed");
                }
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Recreating jar class loader because dependencies have changed.");
                    }
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  New class loader");
            }
            loader = new ModuleClassLoader(library, module);
            ourCache.put(module, loader);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("  Re-used class loader");
        }
        return loader;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    public static void clearCache(Module module) {
        if (ourCache.containsKey(module)) {
            ourCache.remove(module);
        }
    }

    public boolean isClassLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        public ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

